/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.PercentLayout;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class JCollapsiblePane
extends JPanel {
    public static final String ANIMATION_STATE_KEY = "animationState";
    public static final String TOGGLE_ACTION = "toggle";
    public static final String COLLAPSE_ICON = "collapseIcon";
    public static final String EXPAND_ICON = "expandIcon";
    private boolean collapsed = false;
    private Timer animateTimer;
    private final AnimationListener animator;
    private int currentHeight = -1;
    private WrapperContainer wrapper;
    private boolean useAnimation = true;
    private AnimationParams animationParams;

    public JCollapsiblePane() {
        super.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new PercentLayout(1, 2));
        this.setContentPane(panel);
        this.animator = new AnimationListener();
        this.setAnimationParams(new AnimationParams(30, 8, 0.01f, 1.0f));
        this.getActionMap().put(TOGGLE_ACTION, new ToggleAction());
    }

    public void setContentPane(Container contentPanel) {
        if (contentPanel == null) {
            throw new IllegalArgumentException("Content pane can't be null");
        }
        if (this.wrapper != null) {
            super.remove(this.wrapper);
        }
        this.wrapper = new WrapperContainer(contentPanel);
        super.addImpl(this.wrapper, "Center", -1);
    }

    public Container getContentPane() {
        return this.wrapper.c;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.wrapper != null) {
            this.getContentPane().setLayout(mgr);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.getContentPane().add(comp, constraints, index);
    }

    @Override
    public void remove(Component comp) {
        this.getContentPane().remove(comp);
    }

    @Override
    public void remove(int index) {
        this.getContentPane().remove(index);
    }

    @Override
    public void removeAll() {
        this.getContentPane().removeAll();
    }

    public void setAnimated(boolean animated) {
        if (animated != this.useAnimation) {
            this.useAnimation = animated;
            this.firePropertyChange("animated", !this.useAnimation, this.useAnimation);
        }
    }

    public boolean isAnimated() {
        return this.useAnimation;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean val) {
        if (this.collapsed != val) {
            this.collapsed = val;
            if (this.isAnimated()) {
                if (this.collapsed) {
                    this.setAnimationParams(new AnimationParams(30, Math.max(8, this.wrapper.getHeight() / 10), 1.0f, 0.01f));
                    this.animator.reinit(this.wrapper.getHeight(), 0);
                    this.animateTimer.start();
                } else {
                    this.setAnimationParams(new AnimationParams(30, Math.max(8, this.getContentPane().getPreferredSize().height / 10), 0.01f, 1.0f));
                    this.animator.reinit(this.wrapper.getHeight(), this.getContentPane().getPreferredSize().height);
                    this.animateTimer.start();
                }
            } else {
                this.wrapper.c.setVisible(!this.collapsed);
                this.invalidate();
                this.doLayout();
            }
            this.repaint();
            this.firePropertyChange("collapsed", !this.collapsed, this.collapsed);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim;
        if (!this.isAnimated()) {
            dim = this.getContentPane().isVisible() ? this.getContentPane().getPreferredSize() : super.getPreferredSize();
        } else {
            dim = new Dimension(this.getContentPane().getPreferredSize());
            if (!this.getContentPane().isVisible() && this.currentHeight != -1) {
                dim.height = this.currentHeight;
            }
        }
        return dim;
    }

    private void setAnimationParams(AnimationParams params) {
        if (params == null) {
            throw new IllegalArgumentException("params can't be null");
        }
        if (this.animateTimer != null) {
            this.animateTimer.stop();
        }
        this.animationParams = params;
        this.animateTimer = new Timer(this.animationParams.waitTime, this.animator);
        this.animateTimer.setInitialDelay(0);
    }

    private final class WrapperContainer
    extends JPanel {
        float alpha;
        private BufferedImage img;
        private Container c;

        WrapperContainer(Container c) {
            super(new BorderLayout());
            this.alpha = 1.0f;
            this.c = c;
            this.add((Component)c, "Center");
            if (c instanceof JComponent && !((JComponent)c).isOpaque()) {
                ((JComponent)c).setOpaque(true);
            }
        }

        public void showImage() {
            this.makeImage();
            this.c.setVisible(false);
        }

        public void showContent() {
            JCollapsiblePane.this.currentHeight = -1;
            this.c.setVisible(true);
        }

        void makeImage() {
            if (this.getGraphicsConfiguration() != null && this.getWidth() > 0) {
                Dimension dim = this.c.getPreferredSize();
                if (dim.height > 0) {
                    this.img = this.getGraphicsConfiguration().createCompatibleImage(this.getWidth(), dim.height);
                    this.c.setSize(this.getWidth(), dim.height);
                    this.c.paint(this.img.getGraphics());
                } else {
                    this.img = null;
                }
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            if (!JCollapsiblePane.this.useAnimation || this.c.isVisible()) {
                super.paintComponent(g);
            } else {
                if (this.img == null) {
                    this.makeImage();
                }
                if (g != null && this.img != null) {
                    g.drawImage(this.img, 0, this.getHeight() - this.img.getHeight(), null);
                }
            }
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComp = g2d.getComposite();
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, this.alpha);
            g2d.setComposite(alphaComp);
            super.paint(g2d);
            g2d.setComposite(oldComp);
        }
    }

    private final class AnimationListener
    implements ActionListener {
        private final Object animationMutex = "Animation Synchronization Mutex";
        private int startHeight = 0;
        private int finalHeight = 0;
        private float animateAlpha = 1.0f;

        private AnimationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            Object object = this.animationMutex;
            synchronized (object) {
                if (this.startHeight == this.finalHeight) {
                    JCollapsiblePane.this.animateTimer.stop();
                    this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaEnd;
                    if (this.finalHeight > 0) {
                        JCollapsiblePane.this.wrapper.showContent();
                        this.validate();
                        JCollapsiblePane.this.firePropertyChange(JCollapsiblePane.ANIMATION_STATE_KEY, null, "expanded");
                        return;
                    }
                }
                boolean contracting = this.startHeight > this.finalHeight;
                int deltaY = contracting ? -1 * ((JCollapsiblePane)JCollapsiblePane.this).animationParams.deltaY : ((JCollapsiblePane)JCollapsiblePane.this).animationParams.deltaY;
                int newHeight = JCollapsiblePane.this.wrapper.getHeight() + deltaY;
                if (contracting) {
                    if (newHeight < this.finalHeight) {
                        newHeight = this.finalHeight;
                    }
                } else if (newHeight > this.finalHeight) {
                    newHeight = this.finalHeight;
                }
                this.animateAlpha = (float)newHeight / (float)((WrapperContainer)((JCollapsiblePane)JCollapsiblePane.this).wrapper).c.getPreferredSize().height;
                Rectangle bounds = JCollapsiblePane.this.wrapper.getBounds();
                int oldHeight = bounds.height;
                bounds.height = newHeight;
                JCollapsiblePane.this.wrapper.setBounds(bounds);
                bounds = JCollapsiblePane.this.getBounds();
                bounds.height = bounds.height - oldHeight + newHeight;
                JCollapsiblePane.this.currentHeight = bounds.height;
                JCollapsiblePane.this.setBounds(bounds);
                this.startHeight = newHeight;
                if (contracting) {
                    if (this.animateAlpha < ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha > ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaStart;
                    }
                } else {
                    if (this.animateAlpha > ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaEnd) {
                        this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaEnd;
                    }
                    if (this.animateAlpha < ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaStart) {
                        this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaStart;
                    }
                }
                ((JCollapsiblePane)JCollapsiblePane.this).wrapper.alpha = this.animateAlpha;
                this.validate();
            }
        }

        void validate() {
            Container parent = SwingUtilities.getAncestorOfClass(JCollapsiblePaneContainer.class, JCollapsiblePane.this);
            parent = parent != null ? ((JCollapsiblePaneContainer)((Object)parent)).getValidatingContainer() : JCollapsiblePane.this.getParent();
            if (parent != null) {
                if (parent instanceof JComponent) {
                    ((JComponent)parent).revalidate();
                } else {
                    parent.invalidate();
                }
                parent.doLayout();
                parent.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reinit(int startHeight, int stopHeight) {
            Object object = this.animationMutex;
            synchronized (object) {
                JCollapsiblePane.this.firePropertyChange(JCollapsiblePane.ANIMATION_STATE_KEY, null, "reinit");
                this.startHeight = startHeight;
                this.finalHeight = stopHeight;
                this.animateAlpha = ((JCollapsiblePane)JCollapsiblePane.this).animationParams.alphaStart;
                JCollapsiblePane.this.currentHeight = -1;
                JCollapsiblePane.this.wrapper.showImage();
            }
        }
    }

    private static class AnimationParams {
        final int waitTime;
        final int deltaY;
        final float alphaStart;
        final float alphaEnd;

        AnimationParams(int waitTime, int deltaY, float alphaStart, float alphaEnd) {
            this.waitTime = waitTime;
            this.deltaY = deltaY;
            this.alphaStart = alphaStart;
            this.alphaEnd = alphaEnd;
        }
    }

    public static interface JCollapsiblePaneContainer {
        public Container getValidatingContainer();
    }

    private class ToggleAction
    extends AbstractAction
    implements PropertyChangeListener {
        ToggleAction() {
            super(JCollapsiblePane.TOGGLE_ACTION);
            this.updateIcon();
            JCollapsiblePane.this.addPropertyChangeListener("collapsed", this);
        }

        @Override
        public void putValue(String key, Object newValue) {
            super.putValue(key, newValue);
            if (JCollapsiblePane.EXPAND_ICON.equals(key) || JCollapsiblePane.COLLAPSE_ICON.equals(key)) {
                this.updateIcon();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCollapsiblePane.this.setCollapsed(!JCollapsiblePane.this.isCollapsed());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateIcon();
        }

        void updateIcon() {
            if (JCollapsiblePane.this.isCollapsed()) {
                this.putValue("SmallIcon", this.getValue(JCollapsiblePane.EXPAND_ICON));
            } else {
                this.putValue("SmallIcon", this.getValue(JCollapsiblePane.COLLAPSE_ICON));
            }
        }
    }
}

