/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing.renderer;

import com.l2fprod.common.annotations.RendererRegistry;
import com.l2fprod.common.beans.editor.CalendarStringPropertyEditor;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

@RendererRegistry(type={Calendar.class})
public class CalendarRenderer
extends DefaultCellRenderer {
    private DateFormat dateFormat;

    public CalendarRenderer() {
        this(CalendarStringPropertyEditor.DEFAULT_DATE_FORMAT);
    }

    public CalendarRenderer(String formatString) {
        this(formatString, Locale.getDefault());
    }

    public CalendarRenderer(Locale l) {
        this(DateFormat.getDateInstance(3, l));
    }

    public CalendarRenderer(String formatString, Locale l) {
        this(new SimpleDateFormat(formatString, l));
    }

    public CalendarRenderer(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(this.dateFormat.format(((Calendar)value).getTime()));
        }
    }
}

