/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.util;

import java.awt.Toolkit;
import javax.swing.UIManager;

public final class OS {
    private static final boolean OS_IS_MAC_OSX;
    private static final boolean OS_IS_WINDOWS;
    private static final boolean OS_IS_WINDOWS_XP;
    private static final boolean OS_IS_WINDOWS_2003;
    private static final boolean OS_IS_WINDOWS_VISTA;
    private static final boolean OS_IS_LINUX;

    private OS() {
    }

    public static boolean isMacOSX() {
        return OS_IS_MAC_OSX;
    }

    public static boolean isWindows() {
        return OS_IS_WINDOWS;
    }

    public static boolean isWindowsXP() {
        return OS_IS_WINDOWS_XP;
    }

    public static boolean isWindows2003() {
        return OS_IS_WINDOWS_2003;
    }

    public static boolean isWindowsVista() {
        return OS_IS_WINDOWS_VISTA;
    }

    public static boolean isLinux() {
        return OS_IS_LINUX;
    }

    public static boolean isUsingWindowsVisualStyles() {
        if (!OS.isWindows()) {
            return false;
        }
        boolean xpthemeActive = Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive"));
        if (!xpthemeActive) {
            return false;
        }
        try {
            return System.getProperty("swing.noxp") == null;
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    public static String getWindowsVisualStyle() {
        String style = UIManager.getString("win.xpstyle.name");
        if (style == null) {
            style = (String)Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.colorName");
        }
        return style;
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        OS_IS_MAC_OSX = "mac os x".equals(os);
        OS_IS_WINDOWS = os != null && os.contains("windows");
        OS_IS_WINDOWS_XP = "windows xp".equals(os);
        OS_IS_WINDOWS_2003 = "windows 2003".equals(os);
        OS_IS_WINDOWS_VISTA = "windows vista".equals(os);
        OS_IS_LINUX = os != null && os.contains("linux");
    }
}

