/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.util.converter;

import com.l2fprod.common.util.converter.Converter;
import com.l2fprod.common.util.converter.Registry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NumberConverters
implements Converter {
    public static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format;

    public NumberConverters() {
        this(DEFAULT_FORMAT);
    }

    public NumberConverters(NumberFormat format) {
        this.format = format;
    }

    @Override
    public void register(Registry registry) {
        Class[] classes;
        for (Class classe : classes = new Class[]{Number.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Byte.class}) {
            for (Class classe1 : classes) {
                registry.addConverter(classe, classe1, this);
            }
            if (classe.equals(Number.class)) continue;
            registry.addConverter(classe, String.class, this);
            registry.addConverter(String.class, classe, this);
        }
    }

    @Override
    public Object convert(Class<?> targetType, Object value) {
        if (value instanceof Number && Number.class.isAssignableFrom(targetType)) {
            if (Integer.class.equals(targetType)) {
                return ((Number)value).intValue();
            }
            try {
                Method m = value.getClass().getMethod(targetType.getSimpleName().toLowerCase() + "Value", new Class[0]);
                return m.invoke(value, new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(NumberConverters.class.getName()).log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException("this code must not be reached");
            }
            catch (SecurityException ex) {
                Logger.getLogger(NumberConverters.class.getName()).log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException("this code must not be reached");
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(NumberConverters.class.getName()).log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException("this code must not be reached");
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(NumberConverters.class.getName()).log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException("this code must not be reached");
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(NumberConverters.class.getName()).log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException("this code must not be reached");
            }
        }
        if (value instanceof Number && String.class.equals(targetType)) {
            if (value instanceof Double || value instanceof Float) {
                return this.format.format(((Number)value).doubleValue());
            }
            return this.format.format(((Number)value).longValue());
        }
        if (value instanceof String && Number.class.isAssignableFrom(targetType)) {
            if (Integer.class.equals(targetType)) {
                return Integer.parseInt(value.toString());
            }
            try {
                Method m = targetType.getMethod("parse" + targetType.getSimpleName(), String.class);
                return m.invoke(null, value.toString());
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(NumberConverters.class.getName()).log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException("this code must not be reached");
            }
            catch (SecurityException ex) {
                Logger.getLogger(NumberConverters.class.getName()).log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException("this code must not be reached");
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(NumberConverters.class.getName()).log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException("this code must not be reached");
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(NumberConverters.class.getName()).log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException("this code must not be reached");
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(NumberConverters.class.getName()).log(Level.SEVERE, null, ex);
                throw new IllegalArgumentException("this code must not be reached");
            }
        }
        throw new IllegalArgumentException("no conversion supported");
    }

    static {
        DEFAULT_FORMAT.setMinimumIntegerDigits(1);
        DEFAULT_FORMAT.setMaximumIntegerDigits(64);
        DEFAULT_FORMAT.setMinimumFractionDigits(0);
        DEFAULT_FORMAT.setMaximumFractionDigits(64);
    }
}

