/*
 * Decompiled with CFR 0.152.
 */
package org.truth0;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import org.truth0.FailureStrategy;
import org.truth0.IteratingVerb;
import org.truth0.subjects.Subject;
import org.truth0.subjects.SubjectFactory;

@GwtCompatible
public class AbstractVerb {
    private final FailureStrategy failureStrategy;

    public AbstractVerb(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    protected FailureStrategy getFailureStrategy() {
        return this.failureStrategy;
    }

    public void fail() {
        this.failureStrategy.fail("");
    }

    public void fail(String message) {
        this.failureStrategy.fail(message);
    }

    public <S extends Subject<S, T>, T, SF extends SubjectFactory<S, T>> DelegatedVerb<S, T> about(SF factory) {
        return new DelegatedVerb(this.getFailureStrategy(), factory);
    }

    @GwtIncompatible(value="org.truth0.IteratingVerb")
    public <T> IteratingVerb<T> in(Iterable<T> data) {
        return new IteratingVerb<T>(data, this.getFailureStrategy());
    }

    public static class DelegatedVerb<S extends Subject<S, T>, T>
    extends AbstractVerb {
        private final SubjectFactory<S, T> factory;

        public DelegatedVerb(FailureStrategy fs, SubjectFactory<S, T> factory) {
            super(fs);
            this.factory = factory;
        }

        public S that(T target) {
            return this.factory.getSubject(this.getFailureStrategy(), target);
        }
    }
}

