/*
 * Decompiled with CFR 0.152.
 */
package org.truth0;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutionException;
import org.truth0.AbstractVerb;
import org.truth0.FailureStrategy;
import org.truth0.codegen.CompilingClassLoader;
import org.truth0.codegen.IteratingWrapperClassBuilder;
import org.truth0.subjects.Subject;
import org.truth0.subjects.SubjectFactory;

@GwtIncompatible(value="Code generation and loading.")
public class IteratingVerb<T>
extends AbstractVerb {
    private static final String CANNOT_WRAP_MSG = "Cannot build an iterating wrapper around ";
    private static LoadingCache<SubjectFactory<?, ?>, Class<?>> WRAPPER_CACHE = CacheBuilder.newBuilder().build(new CacheLoader<SubjectFactory<?, ?>, Class<?>>(){

        public Class<?> load(SubjectFactory<?, ?> subjectFactory) throws Exception {
            return IteratingVerb.compileWrapperClass(subjectFactory);
        }
    });
    private final Iterable<T> data;

    public IteratingVerb(Iterable<T> data, FailureStrategy fs) {
        super(fs);
        this.data = data;
    }

    public <S extends Subject<S, T>, SF extends SubjectFactory<S, T>> S thatEach(SF factory) {
        return this.wrap(this.getFailureStrategy(), factory, this.data);
    }

    private <S extends Subject<S, T>, SF extends SubjectFactory<S, T>> S wrap(FailureStrategy fs, SF factory, Iterable<T> data) {
        Class<S> t = factory.getSubjectClass();
        try {
            Class wrapperClass = (Class)WRAPPER_CACHE.get(factory);
            return (S)((Subject)this.instantiate(wrapperClass, t, fs, factory, data));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(CANNOT_WRAP_MSG + t, e);
        }
    }

    private <SF, S> S instantiate(Class<?> wrapperType, Type t, FailureStrategy fs, SF factory, Iterable<T> data) {
        try {
            Constructor<?> c = wrapperType.getConstructors()[0];
            return (S)c.newInstance(fs, factory, data);
        }
        catch (SecurityException e) {
            throw new RuntimeException(CANNOT_WRAP_MSG + t, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CANNOT_WRAP_MSG + t, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CANNOT_WRAP_MSG + t, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(CANNOT_WRAP_MSG + t, e);
        }
    }

    private static Class<?> compileWrapperClass(SubjectFactory<?, ?> subjectFactory) {
        CompilingClassLoader classLoader;
        IteratingWrapperClassBuilder builder = new IteratingWrapperClassBuilder(subjectFactory);
        String out = builder.build().toString();
        try {
            classLoader = new CompilingClassLoader(subjectFactory.getSubjectClass().getClassLoader(), builder.className, out, null);
        }
        catch (CompilingClassLoader.CompilerException e) {
            throw new Error("Could not compile class " + builder.className + " with source:\n" + out, e);
        }
        try {
            Class<?> wrapper = classLoader.loadClass(builder.className);
            return wrapper;
        }
        catch (ClassNotFoundException e) {
            throw new Error("Could not load class " + subjectFactory.getSubjectClass().getSimpleName(), e);
        }
    }
}

