/*
 * Decompiled with CFR 0.152.
 */
package org.truth0.subjects;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import org.truth0.FailureStrategy;
import org.truth0.subjects.Subject;
import org.truth0.util.ReflectionUtil;

@GwtCompatible
public class ClassSubject
extends Subject<ClassSubject, Class<?>> {
    public ClassSubject(FailureStrategy failureStrategy, Class<?> o) {
        super(failureStrategy, o);
    }

    @GwtIncompatible(value="Reflection. ")
    public void declaresField(String fieldName) {
        if (this.getSubject() == null) {
            this.failureStrategy.fail("Cannot determine a field name from a null class.");
            return;
        }
        try {
            ReflectionUtil.getField((Class)this.getSubject(), fieldName);
        }
        catch (NoSuchFieldException e) {
            StringBuilder message = new StringBuilder("Not true that ");
            message.append("<").append(((Class)this.getSubject()).getSimpleName()).append(">");
            message.append(" has a field named <").append(fieldName).append(">");
            this.failureStrategy.fail(message.toString());
        }
    }
}

