/*
 * Decompiled with CFR 0.152.
 */
package org.truth0.subjects;

import com.google.common.annotations.GwtCompatible;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.truth0.FailureStrategy;
import org.truth0.subjects.IterableSubject;
import org.truth0.subjects.Ordered;
import org.truth0.subjects.SubjectUtils;

@GwtCompatible
public class CollectionSubject<S extends CollectionSubject<S, T, C>, T, C extends Collection<T>>
extends IterableSubject<S, T, C> {
    public static <T, C extends Collection<T>> CollectionSubject<? extends CollectionSubject<?, T, C>, T, C> create(FailureStrategy failureStrategy, Collection<T> list) {
        return new CollectionSubject(failureStrategy, list);
    }

    protected CollectionSubject(FailureStrategy failureStrategy, C list) {
        super(failureStrategy, list);
    }

    @Override
    public void isEmpty() {
        if (!((Collection)this.getSubject()).isEmpty()) {
            this.fail("is empty", new Object[0]);
        }
    }

    public Has<T, C> has() {
        return new Has<T, C>(){

            @Override
            public void item(T item) {
                if (!((Collection)CollectionSubject.this.getSubject()).contains(item)) {
                    CollectionSubject.this.fail("has item", item);
                }
            }

            @Override
            public void anyOf(T first) {
                this.anyFrom(SubjectUtils.accumulate(first));
            }

            @Override
            public final void anyOf(T first, T second, T ... rest) {
                this.anyFrom(SubjectUtils.accumulate(first, second, rest));
            }

            @Override
            public void anyFrom(Collection<T> col) {
                for (Object item : col) {
                    if (!((Collection)CollectionSubject.this.getSubject()).contains(item)) continue;
                    return;
                }
                CollectionSubject.this.fail("contains", col);
            }

            @Override
            public Ordered allOf(T first) {
                return this.allFrom(SubjectUtils.accumulate(first));
            }

            @Override
            public final Ordered allOf(T first, T second, T ... rest) {
                return this.allFrom(SubjectUtils.accumulate(first, second, rest));
            }

            @Override
            public Ordered allFrom(Collection<T> required) {
                ArrayList toRemove = new ArrayList(required);
                for (Object item : (Collection)CollectionSubject.this.getSubject()) {
                    toRemove.remove(item);
                }
                if (!toRemove.isEmpty()) {
                    CollectionSubject.this.failWithBadResults("has all of", required, "is missing", SubjectUtils.countDuplicates(toRemove));
                }
                return new InOrder("has all in order", required);
            }

            @Override
            public Ordered exactly(T first) {
                return this.exactlyAs(SubjectUtils.accumulate(first));
            }

            @Override
            public final Ordered exactly(T first, T second, T ... rest) {
                return this.exactlyAs(SubjectUtils.accumulate(first, second, rest));
            }

            @Override
            public Ordered exactlyAs(Collection<T> required) {
                ArrayList toRemove = new ArrayList(required);
                ArrayList extra = new ArrayList();
                for (Object item : (Collection)CollectionSubject.this.getSubject()) {
                    if (toRemove.remove(item)) continue;
                    extra.add(item);
                }
                if (!toRemove.isEmpty()) {
                    CollectionSubject.this.failWithBadResults("has exactly", required, "is missing", SubjectUtils.countDuplicates(toRemove));
                }
                if (!extra.isEmpty()) {
                    CollectionSubject.this.failWithBadResults("has exactly", required, "has unexpected items", SubjectUtils.countDuplicates(extra));
                }
                return new InOrder("has exactly in order", required);
            }
        };
    }

    public static interface Has<E, C extends Collection<E>> {
        public void item(E var1);

        public void anyOf(E var1);

        public void anyOf(E var1, E var2, E ... var3);

        public void anyFrom(Collection<E> var1);

        public Ordered allOf(E var1);

        public Ordered allOf(E var1, E var2, E ... var3);

        public Ordered allFrom(Collection<E> var1);

        public Ordered exactly(E var1);

        public Ordered exactly(E var1, E var2, E ... var3);

        public Ordered exactlyAs(Collection<E> var1);
    }

    private class InOrder
    implements Ordered {
        private final String check;
        private final Collection<T> required;

        InOrder(String check, Collection<T> required) {
            this.check = check;
            this.required = required;
        }

        @Override
        public void inOrder() {
            Iterator actualItems = ((Collection)CollectionSubject.this.getSubject()).iterator();
            for (Object expected : this.required) {
                if (!actualItems.hasNext()) {
                    CollectionSubject.this.fail(this.check, this.required);
                    continue;
                }
                Object actual = actualItems.next();
                if (actual == expected || actual != null && actual.equals(expected)) continue;
                CollectionSubject.this.fail(this.check, this.required);
            }
            if (actualItems.hasNext()) {
                CollectionSubject.this.fail(this.check, this.required);
            }
        }
    }
}

