/*
 * Decompiled with CFR 0.152.
 */
package org.truth0.subjects;

import com.google.common.annotations.GwtCompatible;
import org.truth0.FailureStrategy;
import org.truth0.subjects.Subject;
import org.truth0.subjects.SubjectFactory;

@GwtCompatible
public class IntegerSubject
extends Subject<IntegerSubject, Long> {
    public static final SubjectFactory<IntegerSubject, Long> INTEGER = new SubjectFactory<IntegerSubject, Long>(){

        @Override
        public IntegerSubject getSubject(FailureStrategy fs, Long target) {
            return new IntegerSubject(fs, target);
        }
    };

    public IntegerSubject(FailureStrategy failureStrategy, Long i) {
        super(failureStrategy, i);
    }

    public IntegerSubject(FailureStrategy failureStrategy, Integer i) {
        super(failureStrategy, i == null ? null : Long.valueOf(i.longValue()));
    }

    public void isInclusivelyInRange(long lower, long upper) {
        IntegerSubject.ensureOrderedBoundaries(lower, upper);
        if (lower > (Long)this.getSubject() || (Long)this.getSubject() > upper) {
            this.fail("is inclusively in range", lower, upper);
        }
    }

    public void isBetween(long lower, long upper) {
        IntegerSubject.ensureOrderedBoundaries(lower, upper);
        if (lower >= (Long)this.getSubject() || (Long)this.getSubject() >= upper) {
            this.fail("is in between", lower, upper);
        }
    }

    private static void ensureOrderedBoundaries(long lower, long upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("Range inclusion parameter lower (" + lower + ") " + " should not be greater than upper (" + upper + ")");
        }
    }

    public void isEqualTo(Integer other) {
        this.isEqualTo(other == null ? null : Long.valueOf(other.longValue()));
    }

    public void isEqualTo(Long other) {
        if (this.getSubject() == null) {
            if (other != null) {
                this.fail("is equal to", other);
            }
        } else if (!((Long)this.getSubject()).equals(other)) {
            this.fail("is equal to", other);
        }
    }

    public void isNotEqualTo(Integer other) {
        this.isNotEqualTo(other == null ? null : Long.valueOf(other.longValue()));
    }

    public void isNotEqualTo(Long other) {
        if (this.getSubject() == null) {
            if (other == null) {
                this.fail("is not equal to", new Object[]{null});
            }
        } else if (((Long)this.getSubject()).equals(other)) {
            this.fail("is not equal to", other);
        }
    }

    @Override
    public void is(int other) {
        super.is(Long.valueOf(other));
    }

    @Override
    public void is(short other) {
        super.is(Long.valueOf(other));
    }

    @Override
    public void is(byte other) {
        super.is(Long.valueOf(other));
    }
}

