/*
 * Decompiled with CFR 0.152.
 */
package org.truth0.subjects;

import com.google.common.annotations.GwtCompatible;
import java.util.Arrays;
import java.util.Iterator;
import org.truth0.FailureStrategy;
import org.truth0.subjects.Subject;

@GwtCompatible
public class IterableSubject<S extends IterableSubject<S, T, C>, T, C extends Iterable<T>>
extends Subject<S, C> {
    public static <T, C extends Iterable<T>> IterableSubject<? extends IterableSubject<?, T, C>, T, C> create(FailureStrategy failureStrategy, Iterable<T> list) {
        return new IterableSubject(failureStrategy, list);
    }

    protected IterableSubject(FailureStrategy failureStrategy, C list) {
        super(failureStrategy, list);
    }

    public void isEmpty() {
        if (((Iterable)this.getSubject()).iterator().hasNext()) {
            this.fail("is empty", new Object[0]);
        }
    }

    public void isNotEmpty() {
        if (!((Iterable)this.getSubject()).iterator().hasNext()) {
            this.fail("is not empty", new Object[0]);
        }
    }

    public void iteratesAs(Iterable<T> expectedItems) {
        Iterator actualItems = ((Iterable)this.getSubject()).iterator();
        for (T expected : expectedItems) {
            if (!actualItems.hasNext()) {
                this.fail("iterates through", expectedItems);
                continue;
            }
            Object actual = actualItems.next();
            if (actual == expected || actual != null && actual.equals(expected)) continue;
            this.fail("iterates through", expectedItems);
        }
        if (actualItems.hasNext()) {
            this.fail("iterates through", expectedItems);
        }
    }

    @Deprecated
    public void iteratesOverSequence(T ... expectedItems) {
        this.iteratesAs(expectedItems);
    }

    public void iteratesAs(T ... expectedItems) {
        this.iteratesAs((Iterable<T>)Arrays.asList(expectedItems));
    }
}

