/*
 * Decompiled with CFR 0.152.
 */
package org.truth0.subjects;

import com.google.common.annotations.GwtCompatible;
import java.util.Comparator;
import java.util.List;
import org.truth0.FailureStrategy;
import org.truth0.subjects.CollectionSubject;

@GwtCompatible
public class ListSubject<S extends ListSubject<S, T, C>, T, C extends List<T>>
extends CollectionSubject<S, T, C> {
    public static <T, C extends List<T>> ListSubject<? extends ListSubject<?, T, C>, T, C> create(FailureStrategy failureStrategy, List<T> list) {
        return new ListSubject(failureStrategy, list);
    }

    protected ListSubject(FailureStrategy failureStrategy, C list) {
        super(failureStrategy, list);
    }

    public void containsSequence(List<?> sequence) {
        int last;
        int first;
        if (sequence.isEmpty()) {
            return;
        }
        List list = (List)this.getSubject();
        while ((first = list.indexOf(sequence.get(0))) >= 0 && (last = first + sequence.size()) <= list.size()) {
            if (((Object)sequence).equals(list.subList(first, last))) {
                return;
            }
            list = list.subList(first + 1, list.size());
        }
        this.fail("contains sequence", sequence);
    }

    public void isOrdered() {
        this.pairwiseCheck(new PairwiseChecker<T>(){

            @Override
            public void check(T prev, T next) {
                if (((Comparable)prev).compareTo(next) >= 0) {
                    ListSubject.this.fail("is strictly ordered", prev, next);
                }
            }
        });
    }

    public void isPartiallyOrdered() {
        this.pairwiseCheck(new PairwiseChecker<T>(){

            @Override
            public void check(T prev, T next) {
                if (((Comparable)prev).compareTo(next) > 0) {
                    ListSubject.this.fail("is partially ordered", prev, next);
                }
            }
        });
    }

    public void isOrdered(final Comparator<T> comparator) {
        this.pairwiseCheck(new PairwiseChecker<T>(){

            @Override
            public void check(T prev, T next) {
                if (comparator.compare(prev, next) >= 0) {
                    ListSubject.this.fail("is strictly ordered", prev, next);
                }
            }
        });
    }

    public void isPartiallyOrdered(final Comparator<T> comparator) {
        this.pairwiseCheck(new PairwiseChecker<T>(){

            @Override
            public void check(T prev, T next) {
                if (comparator.compare(prev, next) > 0) {
                    ListSubject.this.fail("is partially ordered", prev, next);
                }
            }
        });
    }

    private void pairwiseCheck(PairwiseChecker<T> checker) {
        List list = (List)this.getSubject();
        if (list.size() > 1) {
            Object prev = list.get(0);
            for (int n = 1; n < list.size(); ++n) {
                Object next = list.get(n);
                checker.check(prev, next);
                prev = next;
            }
        }
    }

    private static interface PairwiseChecker<T> {
        public void check(T var1, T var2);
    }
}

