/*
 * Decompiled with CFR 0.152.
 */
package org.truth0.subjects;

import com.google.common.annotations.GwtCompatible;
import java.util.Arrays;
import java.util.Map;
import org.truth0.FailureStrategy;
import org.truth0.subjects.Subject;

@GwtCompatible
public class MapSubject<S extends MapSubject<S, K, V, M>, K, V, M extends Map<K, V>>
extends Subject<S, M> {
    public MapSubject(FailureStrategy failureStrategy, M map) {
        super(failureStrategy, map);
    }

    public void isEmpty() {
        if (!((Map)this.getSubject()).isEmpty()) {
            this.fail("is empty", new Object[0]);
        }
    }

    public void isNotEmpty() {
        if (((Map)this.getSubject()).isEmpty()) {
            this.fail("is not empty", new Object[0]);
        }
    }

    public WithValue<V> hasKey(final K key) {
        if (!((Map)this.getSubject()).containsKey(key)) {
            this.fail("has key", key);
        }
        return new WithValue<V>(){

            @Override
            public void withValue(V expected) {
                Object actual = ((Map)MapSubject.this.getSubject()).get(key);
                if (actual == null && expected != null || actual != expected && !actual.equals(expected)) {
                    MapSubject.this.fail("has key/value pair", Arrays.asList(key, expected), "actually has key/value pair", Arrays.asList(key, actual));
                }
            }
        };
    }

    public void lacksKey(K key) {
        if (((Map)this.getSubject()).containsKey(key)) {
            this.fail("lacks key", key);
        }
    }

    public void hasValue(V key) {
        if (!((Map)this.getSubject()).containsValue(key)) {
            this.fail("has value", key);
        }
    }

    public void lacksValue(V key) {
        if (((Map)this.getSubject()).containsValue(key)) {
            this.fail("lacks value", key);
        }
    }

    public static <K, V, M extends Map<K, V>> MapSubject<? extends MapSubject<?, K, V, M>, K, V, M> create(FailureStrategy failureStrategy, Map<K, V> map) {
        return new MapSubject(failureStrategy, map);
    }

    public static interface WithValue<V> {
        public void withValue(V var1);
    }
}

