/*
 * Decompiled with CFR 0.152.
 */
package org.truth0.subjects;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import java.lang.reflect.Field;
import org.truth0.FailureStrategy;
import org.truth0.TestVerb;
import org.truth0.util.ReflectionUtil;

@GwtCompatible(emulated=true)
public class Subject<S extends Subject<S, T>, T> {
    protected final FailureStrategy failureStrategy;
    private final T subject;

    public Subject(FailureStrategy failureStrategy, T subject) {
        this.failureStrategy = failureStrategy;
        this.subject = subject;
    }

    public void is(T other) {
        if (this.getSubject() == null) {
            if (other != null) {
                this.fail("is", other);
            }
        } else if (!this.getSubject().equals(other)) {
            this.fail("is", other);
        }
    }

    public void isNull() {
        if (this.getSubject() != null) {
            this.failWithoutSubject("is null");
        }
    }

    public void isNotNull() {
        if (this.getSubject() == null) {
            this.failWithoutSubject("is not null");
        }
    }

    public void isEqualTo(Object other) {
        if (this.getSubject() == null) {
            if (other != null) {
                this.fail("is equal to", other);
            }
        } else if (!this.getSubject().equals(other)) {
            this.fail("is equal to", other);
        }
    }

    public void isNotEqualTo(Object other) {
        if (this.getSubject() == null) {
            if (other == null) {
                this.fail("is not equal to", new Object[]{null});
            }
        } else if (this.getSubject().equals(other)) {
            this.fail("is not equal to", other);
        }
    }

    @GwtIncompatible(value="Class.isInstance")
    public void isA(Class<?> clazz) {
        if (!clazz.isInstance(this.getSubject())) {
            this.fail("is a", clazz.getName());
        }
    }

    @GwtIncompatible(value="Class.isInstance")
    public void isNotA(Class<?> clazz) {
        if (clazz.isInstance(this.getSubject())) {
            this.fail("is not a", clazz.getName());
        }
    }

    protected T getSubject() {
        return this.subject;
    }

    protected TestVerb check() {
        return new TestVerb(this.failureStrategy);
    }

    protected void fail(String verb, Object ... messageParts) {
        StringBuilder message = new StringBuilder("Not true that ");
        message.append("<").append(this.getSubject()).append("> ").append(verb);
        for (Object part : messageParts) {
            message.append(" <").append(part).append(">");
        }
        this.failureStrategy.fail(message.toString());
    }

    protected void failWithBadResults(String verb, Object expected, String failVerb, Object actual) {
        StringBuilder message = new StringBuilder("Not true that ");
        message.append("<").append(this.getSubject()).append("> ").append(verb);
        message.append(" <").append(expected).append(">");
        message.append(" it ").append(failVerb);
        message.append(" <").append(actual).append(">");
        this.failureStrategy.fail(message.toString());
    }

    protected void failWithoutSubject(String verb) {
        StringBuilder message = new StringBuilder("Not true that ");
        message.append("the subject ").append(verb);
        this.failureStrategy.fail(message.toString());
    }

    @GwtIncompatible(value="java.lang.reflect.Field")
    public HasField hasField(final String fieldName) {
        Field field;
        final T subject = this.getSubject();
        if (subject == null) {
            this.failureStrategy.fail("Cannot determine a field name from a null object.");
            return new HasField(){

                @Override
                public void withValue(Object value) {
                    Subject.this.fail("Cannot test the presence of a value in a null object.", new Object[0]);
                }
            };
        }
        final Class<?> subjectClass = subject.getClass();
        try {
            field = ReflectionUtil.getField(subjectClass, fieldName);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            StringBuilder message = new StringBuilder("Not true that ");
            message.append("<").append(subjectClass.getSimpleName()).append(">");
            message.append(" has a field named <").append(fieldName).append(">");
            this.failureStrategy.fail(message.toString());
            return new HasField(){

                @Override
                public void withValue(Object value) {
                    Subject.this.fail("Cannot test the presence of a value in a non-present field.", new Object[0]);
                }
            };
        }
        return new HasField(){

            @Override
            public void withValue(Object expected) {
                try {
                    Object actual = field.get(subject);
                    if (expected == actual || expected != null && expected.equals(actual)) {
                        return;
                    }
                    StringBuilder message = new StringBuilder("Not true that ");
                    message.append("<").append(subjectClass.getSimpleName()).append(">'s");
                    message.append(" field <").append(fieldName).append(">");
                    message.append(" contains expected value <").append(expected).append(">.");
                    message.append(" It contains value <").append(actual).append(">");
                    Subject.this.failureStrategy.fail(message.toString());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Error checking field " + fieldName + " while testing for value " + expected);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Cannot access field " + fieldName + " to test for value " + expected);
                }
            }
        };
    }

    @GwtIncompatible(value="java.lang.reflect.Field")
    public static interface HasField {
        public void withValue(Object var1);
    }
}

