/*
 * Decompiled with CFR 0.152.
 */
package org.truth0.util;

import com.google.common.annotations.GwtIncompatible;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

@GwtIncompatible(value="java.lang.reflect.*")
public class ReflectionUtil {
    public static Class<?> typeParameter(Class<?> clazz, int paramIndex) {
        Type superclass = clazz.getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException("" + superclass + " isn't parameterized");
        }
        Type[] typeParams = ((ParameterizedType)superclass).getActualTypeArguments();
        return (Class)typeParams[paramIndex];
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException("No such field " + fieldName + " declared on " + clazz.getSimpleName() + " or its parent classes.");
    }
}

