/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Platform;
import com.google.common.truth.Subject;
import java.util.List;

public abstract class AbstractArraySubject<S extends AbstractArraySubject<S, T>, T>
extends Subject<AbstractArraySubject<S, T>, T> {
    public AbstractArraySubject(FailureStrategy failureStrategy, T subject) {
        super(failureStrategy, subject);
    }

    @Override
    public S named(String name) {
        return (S)((AbstractArraySubject)super.named(name));
    }

    protected abstract String underlyingType();

    protected abstract List<?> listRepresentation();

    @Override
    protected String getDisplaySubject() {
        return this.internalCustomName() == null ? "<(" + this.underlyingType() + "[]) " + this.listRepresentation() + ">" : "\"" + this.internalCustomName() + "\"";
    }

    protected void failWithBadType(Object expected) {
        String expectedType = expected.getClass().isArray() ? expected.getClass().getComponentType().getName() + "[]" : expected.getClass().getName();
        this.failWithRawMessage("Incompatible types compared. expected: %s, actual: %s[]", Platform.compressType(expectedType), this.underlyingType());
    }
}

