/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IteratingVerb;
import com.google.common.truth.StringUtil;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import javax.annotation.CheckReturnValue;

public abstract class AbstractVerb<T extends AbstractVerb<T>> {
    private final FailureStrategy failureStrategy;

    public AbstractVerb(FailureStrategy failureStrategy) {
        this.failureStrategy = failureStrategy;
    }

    protected FailureStrategy getFailureStrategy() {
        return this.getFailureMessage() != null ? new MessageOverridingFailureStrategy(this.failureStrategy, this.getFailureMessage()) : this.failureStrategy;
    }

    public void fail() {
        this.getFailureStrategy().fail("");
    }

    public void fail(String format, Object ... args) {
        this.getFailureStrategy().fail(StringUtil.format(format, args));
    }

    @CheckReturnValue
    public abstract T withFailureMessage(String var1);

    protected abstract String getFailureMessage();

    public <S extends Subject<S, T>, T, SF extends SubjectFactory<S, T>> DelegatedVerb<S, T> about(SF factory) {
        return new DelegatedVerb(this.getFailureStrategy(), factory);
    }

    @GwtIncompatible(value="org.truth0.IteratingVerb")
    public <T> IteratingVerb<T> in(Iterable<T> data) {
        return new IteratingVerb<T>(data, this.getFailureStrategy());
    }

    protected static class MessageOverridingFailureStrategy
    extends FailureStrategy {
        private final FailureStrategy delegate;
        private final String failureMessageOverride;

        protected MessageOverridingFailureStrategy(FailureStrategy delegate, String failureMessage) {
            this.delegate = delegate;
            this.failureMessageOverride = failureMessage;
        }

        @Override
        public void fail(String ignored) {
            this.delegate.fail(this.failureMessageOverride);
        }

        @Override
        public void fail(String message, Throwable cause) {
            this.delegate.fail(this.failureMessageOverride, cause);
        }

        @Override
        public void failComparing(String message, CharSequence ignore, CharSequence ignore2) {
            this.delegate.fail(this.failureMessageOverride);
        }
    }

    public static class DelegatedVerb<S extends Subject<S, T>, T> {
        private final SubjectFactory<S, T> factory;
        private final FailureStrategy failureStrategy;

        public DelegatedVerb(FailureStrategy fs, SubjectFactory<S, T> factory) {
            this.factory = factory;
            this.failureStrategy = fs;
        }

        @CheckReturnValue
        public S that(T target) {
            return this.factory.getSubject(this.failureStrategy, target);
        }
    }
}

