/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.ReflectionUtil;
import com.google.common.truth.Subject;

public class ClassSubject
extends Subject<ClassSubject, Class<?>> {
    public ClassSubject(FailureStrategy failureStrategy, Class<?> o) {
        super(failureStrategy, o);
    }

    @GwtIncompatible(value="Reflection")
    public void declaresField(String fieldName) {
        if (this.getSubject() == null) {
            this.failureStrategy.fail("Cannot determine a field name from a null class.");
            return;
        }
        try {
            ReflectionUtil.getField((Class)this.getSubject(), fieldName);
        }
        catch (NoSuchFieldException e) {
            StringBuilder message = new StringBuilder("Not true that ");
            message.append("<").append(((Class)this.getSubject()).getSimpleName()).append(">");
            message.append(" has a field named <").append(fieldName).append(">");
            this.failureStrategy.fail(message.toString());
        }
    }
}

