/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import java.util.Arrays;
import java.util.Iterator;

public class IterableSubject<S extends IterableSubject<S, T, C>, T, C extends Iterable<T>>
extends Subject<S, C> {
    public static <T, C extends Iterable<T>> IterableSubject<? extends IterableSubject<?, T, C>, T, C> create(FailureStrategy failureStrategy, Iterable<T> list) {
        return new IterableSubject(failureStrategy, list);
    }

    protected IterableSubject(FailureStrategy failureStrategy, C list) {
        super(failureStrategy, list);
    }

    public void isEmpty() {
        if (((Iterable)this.getSubject()).iterator().hasNext()) {
            this.fail("is empty", new Object[0]);
        }
    }

    public void isNotEmpty() {
        if (!((Iterable)this.getSubject()).iterator().hasNext()) {
            this.fail("is not empty", new Object[0]);
        }
    }

    public void iteratesAs(Iterable<?> expectedItems) {
        Iterator actualItems = ((Iterable)this.getSubject()).iterator();
        for (Object expected : expectedItems) {
            if (!actualItems.hasNext()) {
                this.fail("iterates through", expectedItems);
                continue;
            }
            Object actual = actualItems.next();
            if (actual == expected || actual != null && actual.equals(expected)) continue;
            this.fail("iterates through", expectedItems);
        }
        if (actualItems.hasNext()) {
            this.fail("iterates through", expectedItems);
        }
    }

    @Deprecated
    public void iteratesOverSequence(Object ... expectedItems) {
        this.iteratesAs(expectedItems);
    }

    public void iteratesAs(Object ... expectedItems) {
        this.iteratesAs(Arrays.asList(expectedItems));
    }
}

