/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import java.util.regex.Pattern;

public class StringSubject
extends Subject<StringSubject, String> {
    public static final SubjectFactory<StringSubject, String> STRING = new SubjectFactory<StringSubject, String>(){

        @Override
        public StringSubject getSubject(FailureStrategy fs, String target) {
            return new StringSubject(fs, target);
        }
    };

    public StringSubject(FailureStrategy failureStrategy, String string) {
        super(failureStrategy, string);
    }

    @Override
    protected String getDisplaySubject() {
        return this.internalCustomName() == null ? "<" + StringSubject.quote((String)this.getSubject()) + ">" : "\"" + this.internalCustomName() + "\"";
    }

    @Override
    public void is(Object expected) {
        this.isEqualTo(expected);
    }

    @Override
    public void isEqualTo(Object expected) {
        if (this.getSubject() == null) {
            if (expected != null) {
                if (expected instanceof String) {
                    this.failWithRawMessage("Not true that null reference is equal to <%s>", StringSubject.quote((String)expected));
                } else {
                    this.failWithRawMessage("Not true that null reference is equal to (%s)<%s>", expected.getClass().getName(), expected);
                }
            }
        } else if (expected == null) {
            this.isNull();
        } else if (!(expected instanceof String)) {
            this.failWithRawMessage("Not true that %s is equal to (%s)<%s>", this.getDisplaySubject(), expected.getClass().getName(), expected);
        } else if (!((String)this.getSubject()).equals(expected)) {
            if (expected instanceof String) {
                this.failureStrategy.failComparing("", (String)expected, (CharSequence)this.getSubject());
            } else {
                this.failWithRawMessage("Not true that %s equal to (%s)<%s>", this.getDisplaySubject(), expected.getClass().getName(), expected);
            }
        }
    }

    @Override
    public void isNull() {
        if (this.getSubject() != null) {
            this.failWithRawMessage("Not true that %s is null", this.getDisplaySubject());
        }
    }

    public void contains(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot test that a string contains a null reference");
        }
        if (this.getSubject() == null) {
            this.failWithRawMessage("Not true that null reference contains <%s>", StringSubject.quote(string));
        } else if (!((String)this.getSubject()).contains(string)) {
            this.fail("contains", StringSubject.quote(string));
        }
    }

    public void doesNotContain(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot test that a string does not contain a null reference");
        }
        if (this.getSubject() == null) {
            this.failWithRawMessage("Not true that null reference contains <%s>", StringSubject.quote(string));
        } else if (((String)this.getSubject()).contains(string)) {
            this.failWithRawMessage("%s unexpectedly contains <%s>", this.getDisplaySubject(), StringSubject.quote(string));
        }
    }

    public void startsWith(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot test that a string starts with a null reference");
        }
        if (this.getSubject() == null) {
            this.failWithRawMessage("Not true that null reference starts with <%s>", StringSubject.quote(string));
        } else if (!((String)this.getSubject()).startsWith(string)) {
            this.fail("starts with", StringSubject.quote(string));
        }
    }

    public void endsWith(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Cannot test that a string ends with a null reference");
        }
        if (this.getSubject() == null) {
            this.failWithRawMessage("Not true that null reference ends with <%s>", StringSubject.quote(string));
        } else if (!((String)this.getSubject()).endsWith(string)) {
            this.fail("ends with", StringSubject.quote(string));
        }
    }

    private static String quote(String toBeWrapped) {
        return "\"" + toBeWrapped + "\"";
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void matches(String regex) {
        if (!((String)this.getSubject()).matches(regex)) {
            this.fail("matches", regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void matches(Pattern regex) {
        if (!regex.matcher((CharSequence)this.getSubject()).matches()) {
            this.fail("matches", regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void doesNotMatch(String regex) {
        if (((String)this.getSubject()).matches(regex)) {
            this.fail("fails to match", regex);
        }
    }

    @GwtIncompatible(value="java.util.regex.Pattern")
    public void doesNotMatch(Pattern regex) {
        if (regex.matcher((CharSequence)this.getSubject()).matches()) {
            this.fail("fails to match", regex);
        }
    }
}

