/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Platform;
import com.google.common.truth.ReflectionUtil;
import com.google.common.truth.StringUtil;
import com.google.common.truth.TestVerb;
import java.lang.reflect.Field;

public class Subject<S extends Subject<S, T>, T> {
    protected final FailureStrategy failureStrategy;
    private final T subject;
    private String customName = null;

    public Subject(FailureStrategy failureStrategy, T subject) {
        this.failureStrategy = failureStrategy;
        this.subject = subject;
    }

    protected String internalCustomName() {
        return this.customName;
    }

    public S named(String name) {
        if (name == null) {
            throw new NullPointerException("Name passed to named() cannot be null.");
        }
        this.customName = name;
        return (S)this;
    }

    public S labeled(String label) {
        return this.named(label);
    }

    public void is(Object other) {
        this.isEqualTo(other);
    }

    public void isNull() {
        if (this.getSubject() != null) {
            this.failWithoutSubject("is a null reference");
        }
    }

    public void isNotNull() {
        if (this.getSubject() == null) {
            this.failWithoutSubject("is a non-null reference");
        }
    }

    public void isEqualTo(Object other) {
        if (this.getSubject() == null) {
            if (other != null) {
                this.fail("is equal to", other);
            }
        } else if (!this.getSubject().equals(other)) {
            this.fail("is equal to", other);
        }
    }

    public void isNotEqualTo(Object other) {
        if (this.getSubject() == null) {
            if (other == null) {
                this.fail("is not equal to", new Object[]{null});
            }
        } else if (this.getSubject().equals(other)) {
            this.fail("is not equal to", other);
        }
    }

    public void isA(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (!Platform.isInstanceOfType(this.getSubject(), clazz)) {
            if (this.getSubject() != null) {
                this.failWithBadResults("is an instance of", clazz.getName(), "is an instance of", this.getSubject().getClass().getName());
            } else {
                this.fail("is an instance of", clazz.getName());
            }
        }
    }

    public void isNotA(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (this.getSubject() == null) {
            return;
        }
        if (Platform.isInstanceOfType(this.getSubject(), clazz)) {
            this.failWithRawMessage("%s expected not to be an instance of %s, but was.", this.getDisplaySubject(), clazz.getName());
        }
    }

    protected T getSubject() {
        return this.subject;
    }

    protected String getDisplaySubject() {
        return this.customName == null ? "<" + this.getSubject() + ">" : "\"" + this.customName + "\"";
    }

    protected TestVerb check() {
        return new TestVerb(this.failureStrategy);
    }

    protected void fail(String verb, Object ... messageParts) {
        StringBuilder message = new StringBuilder("Not true that ");
        message.append(this.getDisplaySubject()).append(" ").append(verb);
        for (Object part : messageParts) {
            message.append(" <").append(part).append(">");
        }
        this.failureStrategy.fail(message.toString());
    }

    protected void failWithBadResults(String verb, Object expected, String failVerb, Object actual) {
        String message = StringUtil.format("Not true that %s %s <%s>. It %s <%s>", this.getDisplaySubject(), verb, expected, failVerb, actual == null ? "null reference" : actual);
        this.failureStrategy.fail(message);
    }

    protected void failWithCustomSubject(String verb, Object expected, Object actual) {
        String message = StringUtil.format("Not true that <%s> %s <%s>", actual == null ? "null reference" : actual, verb, expected);
        this.failureStrategy.fail(message);
    }

    protected void failWithoutSubject(String verb) {
        String subject = this.customName == null ? "the subject" : "\"" + this.customName + "\"";
        this.failureStrategy.fail(StringUtil.format("Not true that %s %s", subject, verb));
    }

    protected void failWithRawMessage(String message, Object ... parameters) {
        this.failureStrategy.fail(StringUtil.format(message, parameters));
    }

    @GwtIncompatible(value="java.lang.reflect.Field")
    public HasField hasField(final String fieldName) {
        Field field;
        final T subject = this.getSubject();
        if (subject == null) {
            this.failureStrategy.fail("Cannot determine a field name from a null object.");
            return new HasField(){

                @Override
                public void withValue(Object value) {
                    Subject.this.fail("Cannot test the presence of a value in a null object.", new Object[0]);
                }
            };
        }
        final Class<?> subjectClass = subject.getClass();
        try {
            field = ReflectionUtil.getField(subjectClass, fieldName);
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            StringBuilder message = new StringBuilder("Not true that ");
            message.append("<").append(subjectClass.getSimpleName()).append(">");
            message.append(" has a field named <").append(fieldName).append(">");
            this.failureStrategy.fail(message.toString());
            return new HasField(){

                @Override
                public void withValue(Object value) {
                    Subject.this.fail("Cannot test the presence of a value in a non-present field.", new Object[0]);
                }
            };
        }
        return new HasField(){

            @Override
            public void withValue(Object expected) {
                try {
                    Object actual = field.get(subject);
                    if (expected == actual || expected != null && expected.equals(actual)) {
                        return;
                    }
                    StringBuilder message = new StringBuilder("Not true that ");
                    message.append("<").append(subjectClass.getSimpleName()).append(">'s");
                    message.append(" field <").append(fieldName).append(">");
                    message.append(" contains expected value <").append(expected).append(">.");
                    message.append(" It contains value <").append(actual).append(">");
                    Subject.this.failureStrategy.fail(message.toString());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Error checking field " + fieldName + " while testing for value " + expected);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Cannot access field " + fieldName + " to test for value " + expected);
                }
            }
        };
    }

    @Deprecated
    public boolean equals(Object o) {
        this.isEqualTo(o);
        return false;
    }

    @Deprecated
    public int hashCode() {
        throw new UnsupportedOperationException("Equals/Hashcode is not supported on Subjects. Their only use is as a holder of propositions. Use of equals() is deprecated and forwards to isEqualTo() and hashCode() is disallowed.");
    }

    @GwtIncompatible(value="java.lang.reflect.Field")
    public static interface HasField {
        public void withValue(Object var1);
    }
}

