/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.truth.AbstractVerb;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.CollectionSubject;
import com.google.common.truth.DefaultSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.ListSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.OptionalSubject;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;

public class TestVerb
extends AbstractVerb<TestVerb> {
    private final String failureMessage;

    public TestVerb(FailureStrategy failureStrategy) {
        super(failureStrategy);
        this.failureMessage = null;
    }

    public TestVerb(FailureStrategy failureStrategy, String failureMessage) {
        super(failureStrategy);
        this.failureMessage = failureMessage;
    }

    @CheckReturnValue
    public Subject<DefaultSubject, Object> that(Object target) {
        return new DefaultSubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    @GwtIncompatible(value="ClassSubject.java")
    public ClassSubject that(Class<?> target) {
        return new ClassSubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public IntegerSubject that(Long target) {
        return new IntegerSubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public IntegerSubject that(Integer target) {
        return new IntegerSubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public BooleanSubject that(Boolean target) {
        return new BooleanSubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public StringSubject that(String target) {
        return new StringSubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public <T, C extends Iterable<T>> IterableSubject<? extends IterableSubject<?, T, C>, T, C> that(Iterable<T> target) {
        return IterableSubject.create(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public <T, C extends Collection<T>> CollectionSubject<? extends CollectionSubject<?, T, C>, T, C> that(Collection<T> target) {
        return CollectionSubject.create(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public <T, C extends List<T>> ListSubject<? extends ListSubject<?, T, C>, T, C> that(List<T> target) {
        return ListSubject.create(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public <T> ObjectArraySubject<T> that(T[] target) {
        return new ObjectArraySubject<T>(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public PrimitiveBooleanArraySubject that(boolean[] target) {
        return new PrimitiveBooleanArraySubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public PrimitiveIntArraySubject that(int[] target) {
        return new PrimitiveIntArraySubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public PrimitiveLongArraySubject that(long[] target) {
        return new PrimitiveLongArraySubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public PrimitiveCharArraySubject that(char[] target) {
        return new PrimitiveCharArraySubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public PrimitiveFloatArraySubject that(float[] target) {
        return new PrimitiveFloatArraySubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public PrimitiveDoubleArraySubject that(double[] target) {
        return new PrimitiveDoubleArraySubject(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public <T> OptionalSubject<T> that(Optional<T> target) {
        return new OptionalSubject<T>(this.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public <K, V, M extends Map<K, V>> MapSubject<? extends MapSubject<?, K, V, M>, K, V, M> that(Map<K, V> target) {
        return MapSubject.create(this.getFailureStrategy(), target);
    }

    @Override
    @CheckReturnValue
    public TestVerb withFailureMessage(String failureMessage) {
        return new TestVerb(this.getFailureStrategy(), failureMessage);
    }

    @Override
    public String getFailureMessage() {
        return this.failureMessage;
    }
}

