/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Optional;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.ClassSubject;
import com.google.common.truth.CollectionSubject;
import com.google.common.truth.DefaultSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.ListSubject;
import com.google.common.truth.MapSubject;
import com.google.common.truth.ObjectArraySubject;
import com.google.common.truth.OptionalSubject;
import com.google.common.truth.Platform;
import com.google.common.truth.PrimitiveBooleanArraySubject;
import com.google.common.truth.PrimitiveCharArraySubject;
import com.google.common.truth.PrimitiveDoubleArraySubject;
import com.google.common.truth.PrimitiveFloatArraySubject;
import com.google.common.truth.PrimitiveIntArraySubject;
import com.google.common.truth.PrimitiveLongArraySubject;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.TestVerb;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;

public class Truth {
    public static final FailureStrategy THROW_ASSERTION_ERROR = new FailureStrategy(){

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            throw Platform.comparisonFailure(message, ((Object)expected).toString(), ((Object)actual).toString());
        }
    };
    public static final TestVerb ASSERT = new TestVerb(THROW_ASSERTION_ERROR);

    public static TestVerb assert_() {
        return ASSERT;
    }

    private static FailureStrategy getFailureStrategy() {
        return THROW_ASSERTION_ERROR;
    }

    @CheckReturnValue
    public static Subject<DefaultSubject, Object> assertThat(Object target) {
        return new DefaultSubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    @GwtIncompatible(value="ClassSubject.java")
    public static ClassSubject assertThat(Class<?> target) {
        return new ClassSubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static IntegerSubject assertThat(Long target) {
        return new IntegerSubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static IntegerSubject assertThat(Integer target) {
        return new IntegerSubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static BooleanSubject assertThat(Boolean target) {
        return new BooleanSubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static StringSubject assertThat(String target) {
        return new StringSubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static <T, C extends Iterable<T>> IterableSubject<? extends IterableSubject<?, T, C>, T, C> assertThat(Iterable<T> target) {
        return IterableSubject.create(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static <T, C extends Collection<T>> CollectionSubject<? extends CollectionSubject<?, T, C>, T, C> assertThat(Collection<T> target) {
        return CollectionSubject.create(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static <T, C extends List<T>> ListSubject<? extends ListSubject<?, T, C>, T, C> assertThat(List<T> target) {
        return ListSubject.create(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static <T> ObjectArraySubject<T> assertThat(T[] target) {
        return new ObjectArraySubject<T>(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static PrimitiveBooleanArraySubject assertThat(boolean[] target) {
        return new PrimitiveBooleanArraySubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static PrimitiveIntArraySubject assertThat(int[] target) {
        return new PrimitiveIntArraySubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static PrimitiveLongArraySubject assertThat(long[] target) {
        return new PrimitiveLongArraySubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static PrimitiveCharArraySubject assertThat(char[] target) {
        return new PrimitiveCharArraySubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static PrimitiveFloatArraySubject assertThat(float[] target) {
        return new PrimitiveFloatArraySubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static PrimitiveDoubleArraySubject assertThat(double[] target) {
        return new PrimitiveDoubleArraySubject(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static <T> OptionalSubject<T> assertThat(Optional<T> target) {
        return new OptionalSubject<T>(Truth.getFailureStrategy(), target);
    }

    @CheckReturnValue
    public static <K, V, M extends Map<K, V>> MapSubject<? extends MapSubject<?, K, V, M>, K, V, M> assertThat(Map<K, V> target) {
        return MapSubject.create(Truth.getFailureStrategy(), target);
    }
}

