/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import jline.ConsoleReader;
import org.apache.maven.Maven;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.Embedder;
import org.codehaus.plexus.util.StringUtils;
import org.twdata.maven.cli.CommandsCompletor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutePhaseCliMojo
extends AbstractMojo {
    private final List<String> defaultPhases = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("clean");
            this.add("validate");
            this.add("generate-sources");
            this.add("generate-resources");
            this.add("test-compile");
            this.add("test");
            this.add("package");
            this.add("integration-test");
            this.add("install");
            this.add("deploy");
            this.add("site");
            this.add("site-deploy");
        }
    });
    private final List<String> defaultProperties = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("-o");
            this.add("-N");
            this.add("-S");
        }
    });
    private final List<String> listCommands = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("list");
            this.add("ls");
        }
    });
    private final List<String> exitCommands = Collections.unmodifiableList(new ArrayList<String>(){
        {
            this.add("quit");
            this.add("exit");
            this.add("bye");
        }
    });
    private Map<String, String> userAliases;
    private String prompt;
    protected MavenProject project;
    protected MavenSession session;
    protected PluginManager pluginManager;
    protected List reactorProjects;
    protected Map<String, MavenProject> modules;
    protected Embedder embedder;
    protected Maven embeddedMaven;
    protected File userDir;
    private boolean pluginExecutionOfflineMode;

    public void execute() throws MojoExecutionException {
        this.modules = new HashMap<String, MavenProject>();
        for (Object reactorProject : this.reactorProjects) {
            this.modules.put(((MavenProject)reactorProject).getArtifactId(), (MavenProject)reactorProject);
        }
        if (this.userAliases == null) {
            this.userAliases = new HashMap<String, String>();
        }
        this.pluginExecutionOfflineMode = this.session.getSettings().isOffline();
        this.initEmbeddedMaven();
        ArrayList<String> availableCommands = new ArrayList<String>();
        availableCommands.addAll(this.defaultPhases);
        availableCommands.addAll(this.userAliases.keySet());
        availableCommands.addAll(this.exitCommands);
        availableCommands.addAll(this.listCommands);
        availableCommands.addAll(this.modules.keySet());
        availableCommands.addAll(this.defaultProperties);
        this.getLog().info((CharSequence)"Waiting for commands");
        try {
            String line;
            ConsoleReader reader = new ConsoleReader(System.in, new OutputStreamWriter(System.out));
            reader.addCompletor(new CommandsCompletor(availableCommands));
            reader.setBellEnabled(false);
            reader.setDefaultPrompt((this.prompt != null ? this.prompt : "maven2") + "> ");
            while ((line = this.readCommand(reader)) != null) {
                if (StringUtils.isEmpty((String)line)) continue;
                if (this.exitCommands.contains(line)) break;
                if (this.listCommands.contains(line)) {
                    this.getLog().info((CharSequence)"Listing available projects: ");
                    for (Object reactorProject : this.reactorProjects) {
                        this.getLog().info((CharSequence)("* " + ((MavenProject)reactorProject).getArtifactId()));
                    }
                    continue;
                }
                ArrayList<CommandCall> calls = new ArrayList<CommandCall>();
                try {
                    this.parseCommand(line, calls);
                }
                catch (IllegalArgumentException ex) {
                    this.getLog().error((CharSequence)("Invalid command: " + line));
                    continue;
                }
                for (CommandCall call : calls) {
                    this.getLog().debug((CharSequence)("Executing: " + call));
                    long start = System.currentTimeMillis();
                    this.executeCommand(call);
                    long now = System.currentTimeMillis();
                    this.getLog().info((CharSequence)("Execution time: " + (now - start) + " ms"));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute cli commands", (Exception)e);
        }
    }

    private void initEmbeddedMaven() throws MojoExecutionException {
        try {
            this.embedder = new Embedder();
            this.embedder.start();
            this.embeddedMaven = (Maven)this.embedder.lookup(Maven.ROLE);
            this.userDir = new File(System.getProperty("user.dir"));
        }
        catch (PlexusContainerException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void parseCommand(String text, List<CommandCall> commands) {
        ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(text.split(" ")));
        int i = 0;
        while (i < tokens.size()) {
            String token = (String)tokens.get(i);
            if (StringUtils.isEmpty((String)token)) {
                tokens.remove(i);
                continue;
            }
            if (this.userAliases.containsKey(token)) {
                String alias = this.userAliases.get(token);
                ArrayList<String> aliasTokens = new ArrayList<String>(Arrays.asList(alias.split(" ")));
                tokens.remove(i);
                Iterator aliasIter = aliasTokens.iterator();
                while (aliasIter.hasNext()) {
                    if (!StringUtils.isEmpty((String)((String)aliasIter.next()))) continue;
                    aliasIter.remove();
                }
                tokens.addAll(i, aliasTokens);
                continue;
            }
            ++i;
        }
        CommandCall currentCommandCall = null;
        for (String token : tokens) {
            if (this.modules.containsKey(token)) {
                currentCommandCall = this.addProject(commands, currentCommandCall, this.modules.get(token));
                continue;
            }
            if (token.contains("*")) {
                String regexToken = token.replaceAll("\\*", ".*");
                for (String moduleName : this.modules.keySet()) {
                    if (!Pattern.matches(regexToken, moduleName)) continue;
                    currentCommandCall = this.addProject(commands, currentCommandCall, this.modules.get(moduleName));
                }
                continue;
            }
            if (token.equals("-o")) {
                this.goOffline(commands, currentCommandCall);
                continue;
            }
            if (token.equals("-N")) {
                this.disableRecursive(commands, currentCommandCall);
                continue;
            }
            if (token.equals("-S")) {
                this.addProperty(commands, currentCommandCall, "-Dmaven.test.skip=true");
                continue;
            }
            if (token.startsWith("-D")) {
                this.addProperty(commands, currentCommandCall, token);
                continue;
            }
            if (token.startsWith("-P")) {
                this.addProfile(commands, currentCommandCall, token);
                continue;
            }
            currentCommandCall = this.addCommand(commands, currentCommandCall, token);
        }
    }

    private String readCommand(ConsoleReader reader) throws IOException {
        return reader.readLine();
    }

    private CommandCall addProject(List<CommandCall> commands, CommandCall currentCommandCall, MavenProject project) {
        if (currentCommandCall == null || !currentCommandCall.getCommands().isEmpty()) {
            currentCommandCall = new CommandCall();
            commands.add(currentCommandCall);
        }
        currentCommandCall.getProjects().add(project);
        return currentCommandCall;
    }

    private CommandCall addCommand(List<CommandCall> commands, CommandCall currentCommandCall, String command) {
        if (currentCommandCall == null) {
            currentCommandCall = new CommandCall();
            currentCommandCall.getProjects().add(this.project);
            commands.add(currentCommandCall);
        }
        currentCommandCall.getCommands().add(command);
        return currentCommandCall;
    }

    private CommandCall disableRecursive(List<CommandCall> commands, CommandCall currentCommandCall) {
        if (currentCommandCall == null) {
            currentCommandCall = new CommandCall();
            commands.add(currentCommandCall);
        }
        currentCommandCall.doNotRecurse();
        return currentCommandCall;
    }

    private CommandCall goOffline(List<CommandCall> commands, CommandCall currentCommandCall) {
        if (currentCommandCall == null) {
            currentCommandCall = new CommandCall();
            commands.add(currentCommandCall);
        }
        currentCommandCall.goOffline();
        return currentCommandCall;
    }

    private CommandCall addProfile(List<CommandCall> commands, CommandCall currentCommandCall, String profile) {
        if (currentCommandCall == null) {
            currentCommandCall = new CommandCall();
            commands.add(currentCommandCall);
        }
        if (profile.length() < 3) {
            return currentCommandCall;
        }
        profile = profile.substring(2);
        currentCommandCall.getProfiles().add(profile);
        return currentCommandCall;
    }

    private CommandCall addProperty(List<CommandCall> commands, CommandCall currentCommandCall, String property) {
        if (currentCommandCall == null) {
            currentCommandCall = new CommandCall();
            commands.add(currentCommandCall);
        }
        if (property.length() < 3) {
            return currentCommandCall;
        }
        String key = property = property.substring(2);
        String value = "1";
        if (property.indexOf("=") >= 0) {
            String[] propertyTokens = property.split("=");
            key = propertyTokens[0];
            if (propertyTokens.length > 1) {
                value = propertyTokens[1];
            }
        }
        currentCommandCall.getProperties().put(key, value);
        return currentCommandCall;
    }

    private void executeCommand(CommandCall commandCall) {
        for (MavenProject currentProject : commandCall.getProjects()) {
            try {
                this.session.getExecutionProperties().putAll((Map<?, ?>)commandCall.getProperties());
                this.session.setCurrentProject(currentProject);
                this.session.getSettings().setOffline(commandCall.isOffline() ? true : this.pluginExecutionOfflineMode);
                DefaultProfileManager profileManager = new DefaultProfileManager(this.embedder.getContainer(), commandCall.getProperties());
                profileManager.explicitlyActivate(commandCall.getProfiles());
                DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest(this.session.getLocalRepository(), this.session.getSettings(), this.session.getEventDispatcher(), commandCall.getCommands(), this.userDir.getPath(), (ProfileManager)profileManager, this.session.getExecutionProperties(), this.project.getProperties(), true);
                if (!commandCall.isRecursive()) {
                    request.setRecursive(false);
                }
                request.setPomFile(new File(currentProject.getBasedir(), "pom.xml").getPath());
                this.embeddedMaven.execute((MavenExecutionRequest)request);
                this.getLog().info((CharSequence)("Current project: " + this.project.getArtifactId()));
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Failed to execute '" + commandCall.getCommands() + "' on '" + currentProject.getArtifactId() + "'"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommandCall {
        private final List<String> commands = new ArrayList<String>();
        private final List<String> profiles = new ArrayList<String>();
        private final List<MavenProject> projects = new ArrayList<MavenProject>();
        private final Properties properties = new Properties();
        private boolean offline = false;
        private boolean recursive = true;

        public List<MavenProject> getProjects() {
            return this.projects;
        }

        public List<String> getCommands() {
            return this.commands;
        }

        public List<String> getProfiles() {
            return this.profiles;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public boolean isOffline() {
            return this.offline;
        }

        public void goOffline() {
            this.offline = true;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public void doNotRecurse() {
            this.recursive = false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (MavenProject project : this.projects) {
                sb.append("project: ").append(project.getArtifactId()).append(" ");
            }
            for (String command : this.commands) {
                sb.append("command: ").append(command).append(" ");
            }
            for (String profile : this.profiles) {
                sb.append("profile: ").append(profile).append(" ");
            }
            Enumeration<?> propNames = this.properties.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                sb.append("property: ").append(propName).append("=").append(this.properties.get(propName)).append(" ");
            }
            return sb.toString();
        }
    }
}

