/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class IdeaMojo
extends AbstractMojo {
    private static final String MAVEN_CLI_JAR = "maven-cli-idea-plugin.jar";

    public void execute() throws MojoExecutionException {
        File pluginFile;
        File pluginsDir = this.determinePluginsDirViaIdeaPlugins();
        if (pluginsDir == null && (pluginsDir = this.determinePluginsDirViaIdeaHome()) == null) {
            pluginsDir = this.determinePluginsViaDefaults();
        }
        if ((pluginFile = new File(pluginsDir, MAVEN_CLI_JAR)).exists()) {
            pluginFile.delete();
        }
        InputStream source = null;
        FileOutputStream dest = null;
        try {
            int len;
            dest = new FileOutputStream(pluginFile);
            source = ((Object)((Object)this)).getClass().getResourceAsStream("/maven-cli-idea-plugin.jar");
            byte[] buffer = new byte[1024];
            while ((len = source.read(buffer)) > 0) {
                ((OutputStream)dest).write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy IDEA plugin", (Exception)e);
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (dest != null) {
                try {
                    ((OutputStream)dest).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.getLog().info((CharSequence)"IDEA plugin installed");
    }

    File determinePluginsDirViaIdeaHome() throws MojoExecutionException {
        File configDir;
        String path = System.getProperty("idea.home");
        if (path == null) {
            return null;
        }
        File ideaHome = new File(path);
        if (!ideaHome.exists()) {
            throw new MojoExecutionException("The IDEA home directory doesn't exist");
        }
        File pluginsDir = new File(ideaHome, "plugins");
        if (!pluginsDir.exists() && !(pluginsDir = new File(configDir = new File(ideaHome, "config"), "plugins")).exists()) {
            throw new MojoExecutionException("The IDEA plugins directory cannot be found at " + pluginsDir.getAbsolutePath());
        }
        return pluginsDir;
    }

    File determinePluginsDirViaIdeaPlugins() throws MojoExecutionException {
        String path = System.getProperty("idea.plugins");
        if (path == null) {
            return null;
        }
        File pluginsDir = new File(path);
        if (!pluginsDir.exists()) {
            throw new MojoExecutionException("The IDEA plugins directory cannot be found at " + pluginsDir.getAbsolutePath());
        }
        return pluginsDir;
    }

    File determinePluginsViaDefaults() {
        String[] paths;
        for (String path : paths = new String[]{System.getProperty("user.home") + "/.IntelliJIdea80/config/plugins", System.getProperty("user.home") + "/Library/Application Support/IntelliJIDEA80"}) {
            String conv = path.replace('/', File.separatorChar);
            File pluginsDir = new File(conv);
            if (!pluginsDir.exists()) continue;
            return pluginsDir;
        }
        return null;
    }
}

