/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.mojoexecutor.plugin;

import org.apache.commons.lang.reflect.FieldUtils;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.Slf4jConfigurationFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.twdata.maven.mojoexecutor.PlexusConfigurationUtils;

@Mojo(name="execute-mojo", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class MojoExecutorMojo
extends AbstractMojo {
    @Parameter(required=true)
    private Plugin plugin;
    @Parameter(required=true)
    private String goal;
    @Parameter
    private XmlPlexusConfiguration configuration;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter(defaultValue="false")
    private boolean ignoreMavenProject;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Executing with maven project " + this.mavenProject + " for session " + this.mavenSession));
        if (this.quiet) {
            this.disableLogging();
        }
        MojoExecutor.executeMojo((Plugin)this.plugin, (String)this.goal, (Xpp3Dom)PlexusConfigurationUtils.toXpp3Dom((PlexusConfiguration)this.configuration), (MojoExecutor.ExecutionEnvironment)(this.ignoreMavenProject ? MojoExecutor.executionEnvironment((MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager) : MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager)));
    }

    private void disableLogging() throws MojoExecutionException {
        Logger logger;
        try {
            logger = (Logger)FieldUtils.readField((Object)this.getLog(), (String)"logger", (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Unable to access logger field ", (Exception)e);
        }
        logger.setThreshold(5);
        ILoggerFactory slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        Slf4jConfiguration slf4jConfiguration = Slf4jConfigurationFactory.getConfiguration((ILoggerFactory)slf4jLoggerFactory);
        slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.ERROR);
        slf4jConfiguration.activate();
    }
}

