/*
 * Decompiled with CFR 0.152.
 */
package org.twdata.maven.mojoexecutor.plugin;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.Slf4jConfigurationFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import org.twdata.maven.mojoexecutor.PlexusConfigurationUtils;

@Mojo(name="execute-mojo", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class MojoExecutorMojo
extends AbstractMojo {
    private static final Set<String> lockedKeys = new HashSet<String>();
    @Parameter(required=true)
    private Plugin plugin;
    @Parameter(required=true)
    private String goal;
    @Parameter
    private XmlPlexusConfiguration configuration;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter(defaultValue="false")
    private boolean blocking;
    @Parameter(defaultValue="false")
    private boolean ignoreMavenProject;

    public void execute() throws MojoExecutionException {
        block6: {
            block5: {
                this.getLog().info((CharSequence)("Executing with maven project " + this.mavenProject + " for session " + this.mavenSession));
                if (this.quiet) {
                    this.disableLogging();
                }
                if (!this.blocking) break block5;
                String key = String.format("%s:%s", this.plugin.getGroupId(), this.plugin.getArtifactId());
                try {
                    this.lock(key);
                    this.getLog().info((CharSequence)String.format("Executing '%s' in blocking mode.", key));
                    this.executeMojoImpl();
                    this.unlock(key);
                }
                catch (InterruptedException e) {
                    try {
                        String failed = "Failed to execute mojo";
                        this.getLog().error((CharSequence)"Failed to execute mojo", (Throwable)e);
                        throw new MojoExecutionException("Failed to execute mojo", (Exception)e);
                    }
                    catch (Throwable throwable) {
                        this.unlock(key);
                        this.getLog().info((CharSequence)String.format("Released '%s' block.", key));
                        throw throwable;
                    }
                }
                this.getLog().info((CharSequence)String.format("Released '%s' block.", key));
                break block6;
            }
            this.executeMojoImpl();
        }
    }

    private void executeMojoImpl() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)this.plugin, (String)this.goal, (Xpp3Dom)PlexusConfigurationUtils.toXpp3Dom((PlexusConfiguration)this.configuration), (MojoExecutor.ExecutionEnvironment)(this.ignoreMavenProject ? MojoExecutor.executionEnvironment((MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager) : MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager)));
    }

    private void disableLogging() throws MojoExecutionException {
        Logger logger;
        try {
            logger = (Logger)FieldUtils.readField((Object)this.getLog(), (String)"logger", (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Unable to access logger field ", (Exception)e);
        }
        logger.setThreshold(5);
        ILoggerFactory slf4jLoggerFactory = LoggerFactory.getILoggerFactory();
        Slf4jConfiguration slf4jConfiguration = Slf4jConfigurationFactory.getConfiguration((ILoggerFactory)slf4jLoggerFactory);
        slf4jConfiguration.setRootLoggerLevel(Slf4jConfiguration.Level.ERROR);
        slf4jConfiguration.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock(String key) throws InterruptedException {
        Set<String> set = lockedKeys;
        synchronized (set) {
            while (!lockedKeys.add(key)) {
                lockedKeys.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(String key) {
        Set<String> set = lockedKeys;
        synchronized (set) {
            lockedKeys.remove(key);
            lockedKeys.notifyAll();
        }
    }
}

