/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.assigner;

import edu.iu.dsc.tws.data.fs.io.InputSplit;
import edu.iu.dsc.tws.data.fs.io.InputSplitAssigner;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OrderedInputSplitAssigner<T>
implements InputSplitAssigner<T> {
    private static final Logger LOG = Logger.getLogger(OrderedInputSplitAssigner.class.getName());
    private InputSplit<T>[] splits;
    private int numTasks;
    private Map<Integer, Integer> next = new HashMap<Integer, Integer>();

    public OrderedInputSplitAssigner(InputSplit<T>[] partitions, int nTasks) {
        this.numTasks = nTasks;
        this.splits = partitions;
    }

    @Override
    public InputSplit<T> getNextInputSplit(String host, int taskId) {
        int index;
        if (taskId < 0 || taskId > this.numTasks - 1) {
            throw new RuntimeException(String.format("We don't have a split for %d we only support task ids in the range %d - %d", taskId, 0, this.numTasks));
        }
        int count = 0;
        if (this.next.containsKey(taskId)) {
            count = this.next.get(taskId);
        }
        if ((index = count * this.numTasks + taskId) > this.splits.length - 1) {
            return null;
        }
        this.next.put(taskId, count + 1);
        return this.splits[index];
    }
}

