/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.formatters;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.BlockLocation;
import edu.iu.dsc.tws.api.data.FileStatus;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.assigner.LocatableInputSplitAssigner;
import edu.iu.dsc.tws.data.api.formatters.FileInputPartitioner;
import edu.iu.dsc.tws.data.api.splits.BinaryInputSplit;
import edu.iu.dsc.tws.data.api.splits.FileInputSplit;
import edu.iu.dsc.tws.data.fs.io.InputSplitAssigner;
import edu.iu.dsc.tws.data.utils.FileSystemUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class BinaryInputPartitioner
extends FileInputPartitioner<byte[]> {
    private static final long serialVersionUID = -1L;
    private static final Logger LOG = Logger.getLogger(BinaryInputPartitioner.class.getName());
    protected transient int recordLength;
    protected transient int numSplits;

    public BinaryInputPartitioner(Path filePath, int recordLen) {
        super(filePath);
        this.recordLength = recordLen;
    }

    public BinaryInputPartitioner(Path filePath, int recordLen, Config cfg) {
        super(filePath);
        this.recordLength = recordLen;
        this.configure(cfg);
    }

    public BinaryInputPartitioner(Path filePath, int recordLen, int numberOfTasks) {
        super(filePath);
        this.numSplits = numberOfTasks;
        this.recordLength = recordLen;
    }

    public BinaryInputPartitioner(Path filePath, int recordLen, int numberOfTasks, Config config) {
        super(filePath, config);
        this.numSplits = numberOfTasks;
        this.recordLength = recordLen;
    }

    @Override
    public void configure(Config parameters) {
        this.config = parameters;
    }

    @Override
    public FileInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        if (minNumSplits < 1) {
            throw new IllegalArgumentException("Number of input splits has to be at least 1.");
        }
        int curminNumSplits = Math.max(minNumSplits, this.numSplits);
        Path path = this.filePath;
        ArrayList<BinaryInputSplit> inputSplits = new ArrayList<BinaryInputSplit>(curminNumSplits);
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        long totalLength = 0L;
        FileSystem fs = FileSystemUtils.get(path);
        FileStatus pathFile = fs.getFileStatus(path);
        if (pathFile.isDir()) {
            totalLength += this.sumFilesInDir(path, files, true);
        } else {
            files.add(pathFile);
            totalLength += pathFile.getLen();
        }
        if (totalLength % (long)this.recordLength != 0L) {
            throw new IllegalStateException("The Binary file has a incomplete record");
        }
        long numberOfRecords = totalLength / (long)this.recordLength;
        long minRecordsForSplit = Math.floorDiv(numberOfRecords, (long)minNumSplits);
        long oddRecords = numberOfRecords % (long)minNumSplits;
        int splitNum = 0;
        for (FileStatus file : files) {
            long minSplitSize;
            long len = file.getLen();
            long blockSize = file.getBlockSize();
            long currentSplitSize = minSplitSize = minRecordsForSplit * (long)this.recordLength;
            long halfSplit = currentSplitSize >>> 1;
            if (oddRecords > 0L) {
                currentSplitSize += (long)this.recordLength;
                --oddRecords;
            }
            if (len > 0L) {
                Object[] blocks = fs.getFileBlockLocations(file, 0L, len);
                Arrays.sort(blocks);
                long position = 0L;
                int blockIndex = 0;
                for (long bytesUnassigned = len; bytesUnassigned >= currentSplitSize; bytesUnassigned -= currentSplitSize) {
                    blockIndex = this.getBlockIndexForPosition((BlockLocation[])blocks, position, halfSplit, blockIndex);
                    BinaryInputSplit fis = new BinaryInputSplit(splitNum++, file.getPath(), position, currentSplitSize, blocks[blockIndex].getHosts());
                    inputSplits.add(fis);
                    position += currentSplitSize;
                }
                continue;
            }
            throw new IllegalStateException("The binary file " + file.getPath() + " is Empty");
        }
        return inputSplits.toArray(new FileInputSplit[inputSplits.size()]);
    }

    public InputSplitAssigner<byte[]> getInputSplitAssigner(FileInputSplit<byte[]>[] inputSplits) {
        return new LocatableInputSplitAssigner<byte[]>(inputSplits);
    }

    @Override
    protected FileInputSplit createSplit(int num, Path file, long start, long length, String[] hosts) {
        return null;
    }
}

