/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.formatters;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.BlockLocation;
import edu.iu.dsc.tws.api.data.FileStatus;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.InputPartitioner;
import edu.iu.dsc.tws.data.api.splits.CSVInputSplit;
import edu.iu.dsc.tws.data.api.splits.FileInputSplit;
import edu.iu.dsc.tws.data.fs.io.InputSplitAssigner;
import edu.iu.dsc.tws.data.utils.FileSystemUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CSVInputPartitioner<OT>
implements InputPartitioner<OT, FileInputSplit<OT>> {
    private static final Logger LOG = Logger.getLogger(CSVInputPartitioner.class.getName());
    private static final long serialVersionUID = -1L;
    protected transient int numSplits;
    protected Path filePath;
    protected Config config;
    private int dataSize = 0;
    private long minSplitSize = 0L;
    private boolean enumerateNestedFiles = false;

    public CSVInputPartitioner(Path filePath, Config cfg) {
        this.filePath = filePath;
        this.config = cfg;
    }

    public CSVInputPartitioner(Path filePath, Config cfg, int datasize) {
        this.filePath = filePath;
        this.config = cfg;
        this.dataSize = datasize;
    }

    @Override
    public void configure(Config parameters) {
        this.config = parameters;
    }

    public FileInputSplit<OT>[] createInputSplits(int minNumSplits) throws IOException {
        int curminNumSplits = Math.max(minNumSplits, this.numSplits);
        Path path = this.filePath;
        ArrayList<CSVInputSplit> inputSplits = new ArrayList<CSVInputSplit>(curminNumSplits);
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        FileSystem fs = FileSystemUtils.get(path, this.config);
        FileStatus pathFile = fs.getFileStatus(path);
        long totalLength = 0L;
        if (pathFile.isDir()) {
            totalLength += this.sumFilesInDir(path, files, true);
        } else {
            files.add(pathFile);
            totalLength += pathFile.getLen();
        }
        if (files.size() > 1) {
            throw new IllegalStateException("FixedInputPartitioner does not support multiple filescurrently");
        }
        for (FileStatus file : files) {
            CSVInputSplit fis;
            String[] hosts;
            long lineCount = this.dataSize;
            int splSize = (int)(lineCount / (long)curminNumSplits);
            long len = file.getLen();
            long[] splitSizes = this.getSplitSizes(fs, file.getPath(), curminNumSplits, splSize);
            int position = 0;
            if (len > 0L) {
                for (int i = 0; i < splitSizes.length; ++i) {
                    hosts = new String[]{};
                    fis = new CSVInputSplit(i, file.getPath(), position, splitSizes[i], hosts);
                    position = (int)((long)position + splitSizes[i]);
                    inputSplits.add(fis);
                }
                continue;
            }
            BlockLocation[] blocks = fs.getFileBlockLocations(file, 0L, 0L);
            hosts = blocks.length > 0 ? blocks[0].getHosts() : new String[]{};
            fis = new CSVInputSplit(0, file.getPath(), 0L, 0L, hosts);
            inputSplits.add(fis);
        }
        return inputSplits.toArray(new FileInputSplit[inputSplits.size()]);
    }

    private long[] getSplitSizes(FileSystem fs, Path filename, int numberOfSplits, int splitSize) throws IOException {
        long[] splits = new long[numberOfSplits];
        long currentSplitBytes = 0L;
        int currLineCount = 0;
        int completeSplitCount = 0;
        BufferedInputStream bis = new BufferedInputStream((InputStream)fs.open(filename));
        boolean skipLf = true;
        int overflow = -1;
        block0: for (int i = 0; i < numberOfSplits; ++i) {
            currLineCount = 0;
            currentSplitBytes = 0L;
            while (currLineCount < splitSize) {
                char ch;
                int c;
                if (overflow != -1) {
                    c = overflow;
                    ch = (char)c;
                    overflow = -1;
                } else {
                    c = bis.read();
                }
                if (c == -1) break block0;
                ++currentSplitBytes;
                ch = (char)c;
                if (skipLf) {
                    skipLf = false;
                    if (ch == '\n') continue;
                }
                if (ch != '\r' && ch != '\n') continue;
                ++currLineCount;
                if (ch != '\r') continue;
                if (currLineCount == splitSize) {
                    c = bis.read();
                    if (c == -1) break block0;
                    ch = (char)c;
                    if (ch == '\n') {
                        ++currentSplitBytes;
                        continue;
                    }
                    overflow = c;
                    continue;
                }
                skipLf = true;
            }
            splits[i] = currentSplitBytes;
            if (currLineCount != splitSize) continue;
            ++completeSplitCount;
        }
        if (completeSplitCount != numberOfSplits) {
            throw new IllegalStateException(String.format("The file %s could not be split into %d splits with %d lines for each split, please check the input file sizes", filename.toString(), numberOfSplits, splitSize));
        }
        return splits;
    }

    protected abstract FileInputSplit createSplit(int var1, Path var2, long var3, long var5, String[] var7);

    public InputSplitAssigner<OT> getInputSplitAssigner(FileInputSplit<OT>[] inputSplits) {
        return null;
    }

    long sumFilesInDir(Path path, List<FileStatus> files, boolean logExcludedFiles) throws IOException {
        FileSystem fs = FileSystemUtils.get(path);
        long length = 0L;
        for (FileStatus file : fs.listFiles(path)) {
            if (file.isDir()) {
                if (this.acceptFile(file) && this.enumerateNestedFiles) {
                    length += this.sumFilesInDir(file.getPath(), files, logExcludedFiles);
                    continue;
                }
                if (!logExcludedFiles) continue;
                LOG.log(Level.INFO, "Directory " + file.getPath().toString() + " did not pass the file-filter and is excluded.");
                continue;
            }
            if (this.acceptFile(file)) {
                files.add(file);
                length += file.getLen();
                continue;
            }
            if (!logExcludedFiles) continue;
            LOG.log(Level.INFO, "Directory " + file.getPath().toString() + " did not pass the file-filter and is excluded.");
        }
        return length;
    }

    private boolean acceptFile(FileStatus fileStatus) {
        String name = fileStatus.getPath().getName();
        return !name.startsWith("_") && !name.startsWith(".");
    }
}

