/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.formatters;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.BlockLocation;
import edu.iu.dsc.tws.api.data.FSDataInputStream;
import edu.iu.dsc.tws.api.data.FileStatus;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.InputPartitioner;
import edu.iu.dsc.tws.data.api.formatters.FileInputPartitioner;
import edu.iu.dsc.tws.data.api.splits.FileInputSplit;
import edu.iu.dsc.tws.data.utils.FileSystemUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CompleteFileInputPartitioner<OT>
implements InputPartitioner<OT, FileInputSplit<OT>> {
    private static final Logger LOG = Logger.getLogger(FileInputPartitioner.class.getName());
    private static final long serialVersionUID = 1L;
    protected int numSplits = -1;
    public static final long READ_WHOLE_SPLIT_FLAG = -1L;
    private boolean enumerateNestedFiles = false;
    protected Path filePath;
    protected Config config;
    private static final float MAX_SPLIT_SIZE_DISCREPANCY = 1.1f;
    private long minSplitSize = 0L;
    protected FSDataInputStream stream;

    public CompleteFileInputPartitioner(Path filePath) {
        this.filePath = filePath;
    }

    public CompleteFileInputPartitioner(Path filePath, Config cfg) {
        this.filePath = filePath;
        this.config = cfg;
    }

    @Override
    public void configure(Config parameters) {
        this.config = parameters;
    }

    public FileInputSplit<OT>[] createInputSplits(int minNumSplits) throws IOException {
        if (minNumSplits < 1) {
            throw new IllegalArgumentException("Number of input splits has to be at least 1.");
        }
        int curminNumSplits = Math.max(minNumSplits, this.numSplits);
        Path path = this.filePath;
        ArrayList<FileInputSplit> inputSplits = new ArrayList<FileInputSplit>(curminNumSplits);
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        long totalLength = 0L;
        FileSystem fs = FileSystemUtils.get(path, this.config);
        FileStatus pathFile = fs.getFileStatus(path);
        if (pathFile.isDir()) {
            totalLength += this.sumFilesInDir(path, files, true);
        } else {
            files.add(pathFile);
            totalLength += pathFile.getLen();
        }
        long maxSplitSize = totalLength;
        int splitNum = 0;
        for (FileStatus file : files) {
            Object[] blocks;
            long localminSplitSize;
            long len = file.getLen();
            long blockSize = file.getBlockSize();
            if (this.minSplitSize <= blockSize) {
                localminSplitSize = this.minSplitSize;
            } else {
                LOG.log(Level.WARNING, "Minimal split size of " + this.minSplitSize + " is larger than the block size of " + blockSize + ". Decreasing minimal split size to block size.");
                localminSplitSize = blockSize;
            }
            long splitSize = Math.max(localminSplitSize, Math.min(maxSplitSize, blockSize));
            if (len > 0L) {
                blocks = fs.getFileBlockLocations(file, 0L, len);
                Arrays.sort(blocks);
                long position = 0L;
                int blockIndex = 0;
                for (int i = 0; i < curminNumSplits; ++i) {
                    blockIndex = this.getBlockIndexForPosition((BlockLocation[])blocks, position, splitSize, blockIndex);
                    FileInputSplit fis = this.createSplit(splitNum++, file.getPath(), position, splitSize, blocks[blockIndex].getHosts());
                    inputSplits.add(fis);
                }
                continue;
            }
            blocks = fs.getFileBlockLocations(file, 0L, 0L);
            String[] hosts = blocks.length > 0 ? blocks[0].getHosts() : new String[]{};
            for (int i = 0; i < curminNumSplits; ++i) {
                FileInputSplit fis = this.createSplit(splitNum++, file.getPath(), 0L, 0L, hosts);
                inputSplits.add(fis);
            }
        }
        return inputSplits.toArray(new FileInputSplit[inputSplits.size()]);
    }

    protected abstract FileInputSplit createSplit(int var1, Path var2, long var3, long var5, String[] var7);

    long sumFilesInDir(Path path, List<FileStatus> files, boolean logExcludedFiles) throws IOException {
        FileSystem fs = FileSystemUtils.get(path);
        long length = 0L;
        for (FileStatus file : fs.listFiles(path)) {
            if (file.isDir()) {
                if (this.acceptFile(file) && this.enumerateNestedFiles) {
                    length += this.sumFilesInDir(file.getPath(), files, logExcludedFiles);
                    continue;
                }
                if (!logExcludedFiles) continue;
                LOG.log(Level.INFO, "Directory " + file.getPath().toString() + " did not pass the file-filter and is excluded.");
                continue;
            }
            if (this.acceptFile(file)) {
                files.add(file);
                length += file.getLen();
                continue;
            }
            if (!logExcludedFiles) continue;
            LOG.log(Level.INFO, "Directory " + file.getPath().toString() + " did not pass the file-filter and is excluded.");
        }
        return length;
    }

    private boolean acceptFile(FileStatus fileStatus) {
        String name = fileStatus.getPath().getName();
        return !name.startsWith("_") && !name.startsWith(".");
    }

    int getBlockIndexForPosition(BlockLocation[] blocks, long offset, long halfSplitSize, int startIndex) {
        for (int i = startIndex; i < blocks.length; ++i) {
            long blockStart = blocks[i].getOffset();
            long blockEnd = blockStart + blocks[i].getLength();
            if (offset < blockStart || offset >= blockEnd) continue;
            if (i < blocks.length - 1 && blockEnd - offset < halfSplitSize) {
                return i + 1;
            }
            return i;
        }
        throw new IllegalArgumentException("The given offset is not contained in the any block.");
    }
}

