/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.formatters;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.BlockLocation;
import edu.iu.dsc.tws.api.data.FSDataInputStream;
import edu.iu.dsc.tws.api.data.FileStatus;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.InputPartitioner;
import edu.iu.dsc.tws.data.api.splits.FileInputSplit;
import edu.iu.dsc.tws.data.fs.io.InputSplitAssigner;
import edu.iu.dsc.tws.data.utils.FileSystemUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FixedInputPartitioner<OT>
implements InputPartitioner<OT, FileInputSplit<OT>> {
    private static final Logger LOG = Logger.getLogger(FixedInputPartitioner.class.getName());
    private int numSplits = -1;
    private boolean enumerateNestedFiles = false;
    protected Path filePath;
    protected Config config;
    private static final float MAX_SPLIT_SIZE_DISCREPANCY = 1.1f;
    private long minSplitSize = 0L;
    protected FSDataInputStream stream;
    private int dataSize = 0;

    public FixedInputPartitioner(Path filePath) {
        this.filePath = filePath;
    }

    public FixedInputPartitioner(Path filePath, Config cfg) {
        this.filePath = filePath;
        this.config = cfg;
    }

    public FixedInputPartitioner(Path filePath, Config cfg, int datasize) {
        this.filePath = filePath;
        this.config = cfg;
        this.dataSize = datasize;
    }

    @Override
    public void configure(Config parameters) {
        this.config = parameters;
    }

    public FileInputSplit<OT>[] createInputSplits(int minNumSplits) throws IOException {
        int curminNumSplits = Math.max(minNumSplits, this.numSplits);
        Path path = this.filePath;
        ArrayList<FileInputSplit> inputSplits = new ArrayList<FileInputSplit>(curminNumSplits);
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        long totalLength = 0L;
        FileSystem fs = FileSystemUtils.get(path);
        FileStatus pathFile = fs.getFileStatus(path);
        if (pathFile.isDir()) {
            totalLength += this.sumFilesInDir(path, files, true);
        } else {
            files.add(pathFile);
            totalLength += pathFile.getLen();
        }
        long maxSplitSize = totalLength / (long)curminNumSplits + (long)(totalLength % (long)curminNumSplits == 0L ? 0 : 1);
        if (files.size() > 1) {
            throw new IllegalStateException("FixedInputPartitioner does not support multiple filescurrently");
        }
        for (FileStatus file : files) {
            FileInputSplit fis;
            String[] hosts;
            long localminSplitSize;
            long lineCount = this.dataSize;
            int splSize = (int)(lineCount / (long)curminNumSplits);
            long len = file.getLen();
            long blockSize = file.getBlockSize();
            if (this.minSplitSize <= blockSize) {
                localminSplitSize = this.minSplitSize;
            } else {
                LOG.log(Level.WARNING, "Minimal split size of " + this.minSplitSize + " is larger than the block size of " + blockSize + ". Decreasing minimal split size to block size.");
                localminSplitSize = blockSize;
            }
            boolean currLineCount = false;
            long[] splitSizes = this.getSplitSizes(fs, file.getPath(), curminNumSplits, splSize);
            int position = 0;
            if (len > 0L) {
                for (int i = 0; i < splitSizes.length; ++i) {
                    hosts = new String[]{};
                    fis = this.createSplit(i, file.getPath(), position, splitSizes[i], hosts);
                    position = (int)((long)position + splitSizes[i]);
                    inputSplits.add(fis);
                }
                continue;
            }
            BlockLocation[] blocks = fs.getFileBlockLocations(file, 0L, 0L);
            hosts = blocks.length > 0 ? blocks[0].getHosts() : new String[]{};
            fis = this.createSplit(0, file.getPath(), 0L, 0L, hosts);
            inputSplits.add(fis);
        }
        return inputSplits.toArray(new FileInputSplit[inputSplits.size()]);
    }

    private long[] getSplitSizes(FileSystem fs, Path filename, int numberOfSplits, int splitSize) throws IOException {
        long[] splits = new long[numberOfSplits];
        long currentSplitBytes = 0L;
        int currLineCount = 0;
        int completeSplitCount = 0;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(filename), StandardCharsets.UTF_8));
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(filename.getPath()));
        boolean skipLf = false;
        int overflow = -1;
        block0: for (int i = 0; i < numberOfSplits; ++i) {
            currLineCount = 0;
            currentSplitBytes = 0L;
            while (currLineCount < splitSize) {
                char ch;
                int c;
                if (overflow != -1) {
                    c = overflow;
                    ch = (char)c;
                    overflow = -1;
                } else {
                    c = bis.read();
                }
                if (c == -1) break block0;
                ++currentSplitBytes;
                ch = (char)c;
                if (skipLf) {
                    skipLf = false;
                    if (ch == '\n') continue;
                }
                if (ch != '\r' && ch != '\n') continue;
                ++currLineCount;
                if (ch != '\r') continue;
                if (currLineCount == splitSize) {
                    c = bis.read();
                    if (c == -1) break block0;
                    ch = (char)c;
                    if (ch == '\n') {
                        ++currentSplitBytes;
                        continue;
                    }
                    overflow = c;
                    continue;
                }
                skipLf = true;
            }
            splits[i] = currentSplitBytes;
            if (currLineCount != splitSize) continue;
            ++completeSplitCount;
        }
        if (completeSplitCount != numberOfSplits) {
            throw new IllegalStateException(String.format("The file %s could not be split into %d splits with %d lines for each split, please check the input file sizes", filename.toString(), numberOfSplits, splitSize));
        }
        return splits;
    }

    private long getSplitSize(FileSystem fileSystem, Path filename, int start, long end) throws IOException {
        String line;
        int count = start;
        long totalBytes = 0L;
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(filename), StandardCharsets.UTF_8));
        int currentLine = 1;
        while ((line = in.readLine()) != null) {
            if (currentLine <= start) {
                ++currentLine;
                continue;
            }
            byte[] b = line.getBytes(StandardCharsets.UTF_8);
            totalBytes += (long)(b.length + 1);
            if ((long)(++count) != end) continue;
            break;
        }
        return totalBytes;
    }

    long sumFilesInDir(Path path, List<FileStatus> files, boolean logExcludedFiles) throws IOException {
        FileSystem fs = FileSystemUtils.get(path);
        long length = 0L;
        for (FileStatus file : fs.listFiles(path)) {
            if (file.isDir()) {
                if (this.acceptFile(file) && this.enumerateNestedFiles) {
                    length += this.sumFilesInDir(file.getPath(), files, logExcludedFiles);
                    continue;
                }
                if (!logExcludedFiles) continue;
                LOG.log(Level.INFO, "Directory " + file.getPath().toString() + " did not pass the file-filter and is excluded.");
                continue;
            }
            if (this.acceptFile(file)) {
                files.add(file);
                length += file.getLen();
                continue;
            }
            if (!logExcludedFiles) continue;
            LOG.log(Level.INFO, "Directory " + file.getPath().toString() + " did not pass the file-filter and is excluded.");
        }
        return length;
    }

    protected abstract FileInputSplit createSplit(int var1, Path var2, long var3, long var5, String[] var7);

    private boolean acceptFile(FileStatus fileStatus) {
        String name = fileStatus.getPath().getName();
        return !name.startsWith("_") && !name.startsWith(".");
    }

    public InputSplitAssigner<OT> getInputSplitAssigner(FileInputSplit<OT>[] inputSplits) {
        return null;
    }
}

