/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.out;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.FSDataOutputStream;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.data.api.out.FileOutputWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class CSVOutputWriter
extends FileOutputWriter<String> {
    private static final Logger LOG = Logger.getLogger(CSVOutputWriter.class.getName());
    protected static String lineDelimiter = "\n";
    protected static String fieldDelimiter = ",";
    protected static String tabDelimiter = "\t";
    private Map<Integer, PrintWriter> writerMap = new HashMap<Integer, PrintWriter>();
    private boolean allowedNullValues = true;
    private boolean quoteStrings = false;
    private String charsetName;
    private transient Charset charset;
    private String[] headers;
    private Path path;
    private FSDataOutputStream outputStream;
    private Config config;

    public CSVOutputWriter(FileSystem.WriteMode writeMode, Path outPath, Config cfg) {
        this(writeMode, outPath, lineDelimiter, fieldDelimiter, tabDelimiter, cfg, "UTF-8");
    }

    public CSVOutputWriter(FileSystem.WriteMode writeMode, Path outPath, String linedelimiter, String fielddelimiter, String tabdelimiter, Config cfg, String charsetName) {
        super(writeMode, outPath, cfg);
        if (linedelimiter == null) {
            throw new Twister2RuntimeException("line delimiter shouldn't be null");
        }
        if (fielddelimiter == null) {
            throw new Twister2RuntimeException("field delimiter should'nt be null");
        }
        fieldDelimiter = fielddelimiter;
        lineDelimiter = linedelimiter;
        tabDelimiter = tabdelimiter;
        if (this.charset == null) {
            this.charset = Charset.forName(charsetName);
        }
        this.allowedNullValues = false;
        this.path = outPath;
        this.config = cfg;
    }

    public boolean isAllowedNullValues() {
        return this.allowedNullValues;
    }

    public void setAllowedNullValues(boolean allowedNullValues) {
        this.allowedNullValues = allowedNullValues;
    }

    public boolean isQuoteStrings() {
        return this.quoteStrings;
    }

    public void setQuoteStrings(boolean quoteStrings) {
        this.quoteStrings = quoteStrings;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    @Override
    public void createOutput(int partition, FSDataOutputStream out) {
        if (!this.writerMap.containsKey(partition)) {
            this.writerMap.put(partition, new PrintWriter((OutputStream)out));
        }
    }

    public void setHeaders(String[] headerNames) {
        this.headers = headerNames;
    }

    @Override
    public void writeRecord(int partition, String data) {
        if (this.writerMap.containsKey(partition)) {
            this.writerMap.get(partition).println(data);
        }
    }

    public void createOutput() {
        try {
            if (this.fs.exists(this.path)) {
                this.fs.delete(this.path, true);
            }
            this.outputStream = this.fs.create(new Path(this.path, CSVOutputWriter.generateRandom(10) + ".csv"));
            this.pw = new PrintWriter((OutputStream)this.outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException Occured");
        }
    }

    @Override
    public void writeRecord(String data) {
        if (this.headers != null && this.headers.length != 0) {
            for (int i = 0; i < this.headers.length; ++i) {
                this.pw.write(this.headers[i]);
                if (i >= this.headers.length - 1) continue;
                this.pw.write(fieldDelimiter);
                this.pw.write(tabDelimiter);
            }
            this.pw.write(lineDelimiter);
        }
        this.pw.write(data);
    }

    @Override
    public void close() {
        if (!this.writerMap.isEmpty()) {
            for (PrintWriter pw1 : this.writerMap.values()) {
                pw1.close();
            }
            this.writerMap.clear();
        } else {
            this.pw.close();
        }
        super.close();
    }
}

