/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.out;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.FSDataOutputStream;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.OutputWriter;
import edu.iu.dsc.tws.data.utils.FileSystemUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.RandomStringUtils;

public abstract class FileOutputWriter<T>
implements OutputWriter<T> {
    private static final Logger LOG = Logger.getLogger(FileOutputWriter.class.getName());
    protected FileSystem fs;
    protected PrintWriter pw;
    protected Map<Integer, FSDataOutputStream> openStreams = new HashMap<Integer, FSDataOutputStream>();
    protected FileSystem.WriteMode writeMode;
    protected Path outPath;

    public FileOutputWriter(FileSystem.WriteMode writeMode, Path outPath) {
        this.writeMode = writeMode;
        this.outPath = outPath;
        try {
            this.fs = FileSystemUtils.get(outPath.toUri());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create file system for : " + outPath.toUri());
        }
    }

    public FileOutputWriter(FileSystem.WriteMode writeMode, Path outPath, Config config) {
        this.writeMode = writeMode;
        this.outPath = outPath;
        try {
            this.fs = FileSystemUtils.get(outPath.toUri(), config);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create file system for : " + outPath.toUri());
        }
    }

    @Override
    public void write(int partition, T out) {
        if (!this.openStreams.containsKey(partition)) {
            Path path = new Path(this.outPath, "part-" + partition);
            try {
                FSDataOutputStream fsOut = this.fs.create(path);
                this.createOutput(partition, fsOut);
                this.openStreams.put(partition, fsOut);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create output stream for file: " + path, e);
            }
        }
        this.writeRecord(partition, out);
    }

    @Override
    public void write(T out) {
        try {
            if (this.fs.exists(this.outPath)) {
                this.fs.delete(this.outPath, true);
            }
            FSDataOutputStream fsOut = this.fs.create(new Path(this.outPath, FileOutputWriter.generateRandom(10) + ".csv"));
            this.pw = new PrintWriter((OutputStream)fsOut);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException Occured");
        }
        this.writeRecord(out);
    }

    public static String generateRandom(int length) {
        boolean useLetters = true;
        boolean useNumbers = false;
        return RandomStringUtils.random((int)length, (boolean)useLetters, (boolean)useNumbers);
    }

    protected abstract void createOutput(int var1, FSDataOutputStream var2);

    protected abstract void writeRecord(int var1, T var2);

    protected abstract void writeRecord(T var1);

    @Override
    public void configure(Config config) {
    }

    @Override
    public void close() {
        for (FSDataOutputStream o : this.openStreams.values()) {
            try {
                o.close();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Failed to close the output stream", e);
            }
        }
        this.openStreams.clear();
    }
}

