/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.out;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.FSDataOutputStream;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.out.FileOutputWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class TextOutputWriter
extends FileOutputWriter<String> {
    private Map<Integer, PrintWriter> writerMap = new HashMap<Integer, PrintWriter>();
    protected static String lineDelimiter = "\n";
    protected static String fieldDelimiter = ",";
    protected static String tabDelimiter = "\t";
    private String[] headers;
    private Path path;
    private FSDataOutputStream outputStream;
    private Config config;

    public TextOutputWriter(FileSystem.WriteMode writeMode, Path outPath) {
        super(writeMode, outPath);
    }

    public TextOutputWriter(FileSystem.WriteMode writeMode, Path outPath, Config cfg) {
        super(writeMode, outPath, cfg);
        this.config = cfg;
        this.path = outPath;
    }

    @Override
    public void createOutput(int partition, FSDataOutputStream out) {
        if (!this.writerMap.containsKey(partition)) {
            this.writerMap.put(partition, new PrintWriter((OutputStream)out));
        }
    }

    @Override
    public void writeRecord(int partition, String data) {
        if (this.writerMap.containsKey(partition)) {
            this.writerMap.get(partition).println(data);
        }
    }

    public void setHeaders(String[] headerNames) {
        this.headers = headerNames;
    }

    public void createOutput() {
        try {
            if (this.fs.exists(this.path)) {
                this.fs.delete(this.path, true);
            }
            this.outputStream = this.fs.create(new Path(this.path, TextOutputWriter.generateRandom(10) + ".txt"));
            this.pw = new PrintWriter((OutputStream)this.outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException Occured");
        }
    }

    @Override
    public void writeRecord(String data) {
        if (this.headers != null && this.headers.length != 0) {
            for (int i = 0; i < this.headers.length; ++i) {
                this.pw.write(this.headers[i]);
                if (i >= this.headers.length - 1) continue;
                this.pw.write(fieldDelimiter);
                this.pw.write(tabDelimiter);
            }
            this.pw.write(lineDelimiter);
        }
        this.pw.write(data);
    }

    @Override
    public void close() {
        if (!this.writerMap.isEmpty()) {
            for (PrintWriter pw1 : this.writerMap.values()) {
                pw1.close();
            }
            this.writerMap.clear();
        } else {
            this.pw.close();
        }
        super.close();
    }
}

