/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.splits;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.splits.FileInputSplit;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.logging.Logger;

public class BinaryInputSplit
extends FileInputSplit<byte[]> {
    private static final Logger LOG = Logger.getLogger(BinaryInputSplit.class.getName());
    protected static final String RECORD_LENGTH = "binary-format.record-length";
    protected static final int DEFAULT_RECORD_LENGTH = 8;
    private ByteOrder endianess = ByteOrder.BIG_ENDIAN;
    private static final int DEFAULT_READ_BUFFER_SIZE = 0x100000;
    private int bufferSize = -1;
    protected transient int recordLength;
    private transient byte[] readBuffer;
    private transient byte[] wrapBuffer;
    private transient int readPos;
    private transient int limit;
    private transient byte[] currBuffer;
    private transient int currOffset;
    private transient int currLen;
    private transient boolean overLimit;
    private transient boolean end;
    private long offset = -1L;
    private Config config;

    public BinaryInputSplit(int num, Path file, long start, long length, String[] hosts) {
        super(num, file, start, length, hosts);
    }

    public BinaryInputSplit(int num, Path file, int recordLen, String[] hosts) {
        super(num, file, hosts);
        this.recordLength = recordLen;
    }

    public ByteOrder getEndianess() {
        return this.endianess;
    }

    public void setEndianess(ByteOrder order) {
        if (this.endianess == null) {
            throw new IllegalArgumentException("Endianess must not be null");
        }
        this.endianess = order;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int buffSize) {
        if (buffSize < 2) {
            throw new IllegalArgumentException("Buffer size must be at least 2.");
        }
        this.bufferSize = buffSize;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void setRecordLength(int recordLen) {
        if (recordLen <= 0) {
            throw new IllegalArgumentException("RecordLength must be larger than 0");
        }
        this.recordLength = recordLen;
        if (this.bufferSize % recordLen != 0) {
            int bufferFactor = 1;
            bufferFactor = this.bufferSize > 0 ? this.bufferSize / recordLen : 0x100000 / recordLen;
            if (bufferFactor >= 1) {
                this.setBufferSize(recordLen * bufferFactor);
            } else {
                this.setBufferSize(recordLen * 8);
            }
        }
    }

    @Override
    public void configure(Config parameters) {
        super.configure(parameters);
        int datasize = Integer.parseInt(String.valueOf(parameters.get("dsize")));
        int recordLen = datasize * 2;
        if (recordLen > 0) {
            this.setRecordLength(recordLen);
        }
    }

    @Override
    public void open() throws IOException {
        super.open();
        this.initBuffers();
        long recordMod = this.splitStart % (long)this.recordLength;
        if (recordMod != 0L) {
            this.offset = this.splitStart + (long)this.recordLength - recordMod;
            if (this.offset > this.splitStart + this.splitLength) {
                this.end = true;
            }
        } else {
            this.offset = this.splitStart;
        }
        if (this.splitStart != 0L) {
            this.stream.seek(this.offset);
        }
        this.fillBuffer(0);
    }

    @Override
    public void open(Config cfg) throws IOException {
        super.open(cfg);
        this.configure(cfg);
        this.initBuffers();
        long recordMod = this.splitStart % (long)this.recordLength;
        if (recordMod != 0L) {
            this.offset = this.splitStart + (long)this.recordLength - recordMod;
            if (this.offset > this.splitStart + this.splitLength) {
                this.end = true;
            }
        } else {
            this.offset = this.splitStart;
        }
        if (this.splitStart != 0L) {
            this.stream.seek(this.offset);
        }
        this.fillBuffer(0);
    }

    @Override
    public boolean reachedEnd() {
        return this.end;
    }

    @Override
    public byte[] nextRecord(byte[] record) throws IOException {
        if (this.checkAndBufferRecord()) {
            return this.readRecord(record, this.readBuffer, this.currOffset, this.currLen);
        }
        this.end = true;
        return null;
    }

    public byte[] readRecord(byte[] reusable, byte[] bytes, int readOffset, int numBytes) throws IOException {
        if (reusable != null && reusable.length == this.recordLength) {
            System.arraycopy(bytes, readOffset, reusable, 0, numBytes);
            return reusable;
        }
        byte[] tmp = new byte[this.recordLength];
        System.arraycopy(bytes, readOffset, tmp, 0, numBytes);
        return tmp;
    }

    private boolean checkAndBufferRecord() throws IOException {
        if (this.readPos < this.limit) {
            this.currOffset = this.readPos;
            this.currLen = this.recordLength;
            this.readPos += this.recordLength;
            return true;
        }
        if (this.fillBuffer(0)) {
            this.currOffset = this.readPos;
            this.currLen = this.recordLength;
            this.readPos += this.recordLength;
            return true;
        }
        return false;
    }

    private void initBuffers() {
        int n = this.bufferSize = this.bufferSize <= 0 ? 0x100000 : this.bufferSize;
        if (this.bufferSize % this.recordLength != 0) {
            throw new IllegalArgumentException("Buffer size must be a multiple of the record length");
        }
        if (this.readBuffer == null || this.readBuffer.length != this.bufferSize) {
            this.readBuffer = new byte[this.bufferSize];
        }
        if (this.wrapBuffer == null || this.wrapBuffer.length < 256) {
            this.wrapBuffer = new byte[256];
        }
        this.readPos = 0;
        this.limit = 0;
        this.overLimit = false;
        this.end = false;
    }

    private boolean fillBuffer(int fillOffset) throws IOException {
        int maxReadLength = this.readBuffer.length - fillOffset;
        if (this.splitLength == -1L) {
            int read = this.stream.read(this.readBuffer, fillOffset, maxReadLength);
            if (read == -1) {
                this.stream.close();
                this.stream = null;
                return false;
            }
            this.readPos = fillOffset;
            this.limit = read;
            return true;
        }
        if (this.splitLength <= 0L) {
            int toRead = maxReadLength;
            this.overLimit = true;
            return false;
        }
        int toRead = this.splitLength > (long)maxReadLength ? maxReadLength : (int)this.splitLength;
        int read = this.stream.read(this.readBuffer, fillOffset, toRead);
        if (read == -1) {
            this.stream.close();
            this.stream = null;
            return false;
        }
        this.splitLength -= (long)read;
        this.readPos = fillOffset;
        this.limit = read + fillOffset;
        return true;
    }
}

