/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.splits;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.splits.FileInputSplit;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.logging.Logger;

public abstract class DelimitedInputSplit<OT>
extends FileInputSplit<OT> {
    private static final Logger LOG = Logger.getLogger(DelimitedInputSplit.class.getName());
    private String charsetName = "UTF-8";
    private transient Charset charset;
    private static final int DEFAULT_READ_BUFFER_SIZE = 0x100000;
    protected static final String RECORD_DELIMITER = "delimited-format.delimiter";
    private byte[] delimiter = new byte[]{10};
    private String delimiterString = null;
    private int lineLengthLimit = Integer.MAX_VALUE;
    private int bufferSize = -1;
    private transient byte[] readBuffer;
    private transient byte[] wrapBuffer;
    private transient int readPos;
    private transient int limit;
    private transient byte[] currBuffer;
    private transient int currOffset;
    private transient int currLen;
    private transient boolean overLimit;
    private transient boolean end;
    private long offset = -1L;
    private Config config;

    public DelimitedInputSplit(int num, Path file, long start, long length, String[] hosts) {
        super(num, file, start, length, hosts);
    }

    public byte[] getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(byte[] delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Delimiter must not be null");
        }
        this.delimiter = delimiter;
    }

    public String getDelimiterString() {
        return this.delimiterString;
    }

    public void setDelimiterString(String delimiterString) {
        if (this.delimiter == null) {
            throw new IllegalArgumentException("Delimiter must not be null");
        }
        this.delimiter = delimiterString.getBytes(this.getCharset());
        this.delimiterString = delimiterString;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 2) {
            throw new IllegalArgumentException("Buffer size must be at least 2.");
        }
        this.bufferSize = bufferSize;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public int getLineLengthLimit() {
        return this.lineLengthLimit;
    }

    public void setLineLengthLimit(int lineLengthLimit) {
        this.lineLengthLimit = lineLengthLimit;
    }

    public Charset getCharset() {
        if (this.charset == null) {
            this.charset = Charset.forName(this.charsetName);
        }
        return this.charset;
    }

    @Override
    public void configure(Config parameters) {
        String delimString;
        super.configure(parameters);
        this.config = parameters;
        if (Arrays.equals(this.delimiter, new byte[]{10}) && (delimString = parameters.getStringValue(RECORD_DELIMITER, null)) != null) {
            this.setDelimiterString(delimString);
        }
    }

    @Override
    public void open(Config cfg) throws IOException {
        super.open(cfg);
        this.initBuffers();
        this.offset = this.splitStart;
        if (this.splitStart != 0L) {
            this.stream.seek(this.offset);
            if (this.overLimit) {
                this.end = true;
            }
        } else {
            this.fillBuffer(0);
        }
    }

    public abstract OT readRecord(OT var1, byte[] var2, int var3, int var4) throws IOException;

    @Override
    public OT nextRecord(OT record) throws IOException {
        if (this.readLine()) {
            return this.readRecord(record, this.currBuffer, this.currOffset, this.currLen);
        }
        this.end = true;
        return null;
    }

    private void initBuffers() {
        int n = this.bufferSize = this.bufferSize <= 0 ? 0x100000 : this.bufferSize;
        if (this.bufferSize <= this.delimiter.length) {
            throw new IllegalArgumentException("Buffer size must be greater than length of delimiter.");
        }
        if (this.readBuffer == null || this.readBuffer.length != this.bufferSize) {
            this.readBuffer = new byte[this.bufferSize];
        }
        if (this.wrapBuffer == null || this.wrapBuffer.length < 256) {
            this.wrapBuffer = new byte[256];
        }
        this.readPos = 0;
        this.limit = 0;
        this.overLimit = false;
        this.end = false;
    }

    private boolean fillBuffer(int fillOffset) throws IOException {
        int toRead;
        int maxReadLength = this.readBuffer.length - fillOffset;
        if (this.splitLength == -1L) {
            int read = this.stream.read(this.readBuffer, fillOffset, maxReadLength);
            if (read == -1) {
                this.stream.close();
                this.stream = null;
                return false;
            }
            this.readPos = fillOffset;
            this.limit = read;
            return true;
        }
        if (this.splitLength > 0L) {
            toRead = this.splitLength > (long)maxReadLength ? maxReadLength : (int)this.splitLength;
        } else {
            toRead = maxReadLength;
            this.overLimit = true;
        }
        int read = this.stream.read(this.readBuffer, fillOffset, toRead);
        if (read == -1) {
            this.stream.close();
            this.stream = null;
            return false;
        }
        this.splitLength -= (long)read;
        this.readPos = fillOffset;
        this.limit = read + fillOffset;
        return true;
    }

    protected final boolean readLine() throws IOException {
        if (this.stream == null || this.overLimit) {
            return false;
        }
        int countInWrapBuffer = 0;
        int delimPos = 0;
        while (true) {
            int count;
            if (this.readPos >= this.limit && !this.fillBuffer(delimPos)) {
                int countInReadBuffer = delimPos;
                if (countInWrapBuffer + countInReadBuffer > 0) {
                    if (countInReadBuffer > 0) {
                        if (this.wrapBuffer.length - countInWrapBuffer < countInReadBuffer) {
                            byte[] tmp = new byte[countInWrapBuffer + countInReadBuffer];
                            System.arraycopy(this.wrapBuffer, 0, tmp, 0, countInWrapBuffer);
                            this.wrapBuffer = tmp;
                        }
                        System.arraycopy(this.readBuffer, 0, this.wrapBuffer, countInWrapBuffer, countInReadBuffer);
                        countInWrapBuffer += countInReadBuffer;
                    }
                    this.offset += (long)countInWrapBuffer;
                    this.setResult(this.wrapBuffer, 0, countInWrapBuffer);
                    return true;
                }
                return true;
            }
            int startPos = this.readPos - delimPos;
            while (this.readPos < this.limit && delimPos < this.delimiter.length) {
                if (this.readBuffer[this.readPos] == this.delimiter[delimPos]) {
                    ++delimPos;
                } else {
                    this.readPos -= delimPos;
                    delimPos = 0;
                }
                ++this.readPos;
            }
            if (this.readPos == this.limit) {
                this.end = true;
            }
            if (delimPos == this.delimiter.length) {
                int readBufferBytesRead = this.readPos - startPos;
                this.offset += (long)(countInWrapBuffer + readBufferBytesRead);
                count = readBufferBytesRead - this.delimiter.length;
                if (countInWrapBuffer > 0) {
                    if (this.wrapBuffer.length < countInWrapBuffer + count) {
                        byte[] nb = new byte[countInWrapBuffer + count];
                        System.arraycopy(this.wrapBuffer, 0, nb, 0, countInWrapBuffer);
                        this.wrapBuffer = nb;
                    }
                    if (count >= 0) {
                        System.arraycopy(this.readBuffer, 0, this.wrapBuffer, countInWrapBuffer, count);
                    }
                    this.setResult(this.wrapBuffer, 0, countInWrapBuffer + count);
                    return true;
                }
                this.setResult(this.readBuffer, startPos, count);
                return true;
            }
            count = this.limit - startPos;
            if ((long)countInWrapBuffer + (long)count > (long)this.lineLengthLimit) {
                throw new IOException("The record length exceeded the maximum record length (" + this.lineLengthLimit + ").");
            }
            int bytesToMove = count - delimPos;
            if (this.wrapBuffer.length - countInWrapBuffer < bytesToMove) {
                byte[] tmp = new byte[Math.max(this.wrapBuffer.length * 2, countInWrapBuffer + bytesToMove)];
                System.arraycopy(this.wrapBuffer, 0, tmp, 0, countInWrapBuffer);
                this.wrapBuffer = tmp;
            }
            System.arraycopy(this.readBuffer, startPos, this.wrapBuffer, countInWrapBuffer, bytesToMove);
            countInWrapBuffer += bytesToMove;
            System.arraycopy(this.readBuffer, this.readPos - delimPos, this.readBuffer, 0, delimPos);
        }
    }

    private void setResult(byte[] buffer, int resultOffset, int len) {
        this.currBuffer = buffer;
        this.currOffset = resultOffset;
        this.currLen = len;
    }

    @Override
    public void close() throws IOException {
        this.wrapBuffer = null;
        this.readBuffer = null;
        super.close();
    }

    @Override
    public boolean reachedEnd() {
        return this.end;
    }
}

