/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.splits;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.FSDataInputStream;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.splits.LocatableInputSplit;
import edu.iu.dsc.tws.data.utils.FileSystemUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class FileInputSplit<OT>
extends LocatableInputSplit<OT> {
    private static final Logger LOG = Logger.getLogger(FileInputSplit.class.getName());
    private static final long serialVersionUID = 1L;
    private final Path file;
    private long start;
    private long length;
    protected int numSplits = -1;
    protected boolean enumerateNestedFiles = false;
    protected static final float MAX_SPLIT_SIZE_DISCREPANCY = 1.1f;
    protected long minSplitSize = 0L;
    protected long splitStart;
    protected long splitLength;
    protected FSDataInputStream stream;
    protected long openTimeout;
    private Config config;

    public FileInputSplit(int num, Path file, long start, long length, String[] hosts) {
        super(num, hosts);
        this.file = file;
        this.start = start;
        this.length = length;
    }

    public FileInputSplit(int num, Path file, String[] hosts) {
        super(num, hosts);
        this.file = file;
    }

    public boolean isEnumerateNestedFiles() {
        return this.enumerateNestedFiles;
    }

    public void setEnumerateNestedFiles(boolean enumerateNestedFiles) {
        this.enumerateNestedFiles = enumerateNestedFiles;
    }

    public long getMinSplitSize() {
        return this.minSplitSize;
    }

    public void setMinSplitSize(long minSplitSize) {
        if (minSplitSize < 0L) {
            throw new IllegalArgumentException("The minimum split size cannot be negative.");
        }
        this.minSplitSize = minSplitSize;
    }

    public int getNumSplits() {
        return this.numSplits;
    }

    public void setNumSplits(int numSplits) {
        if (numSplits < -1 || numSplits == 0) {
            throw new IllegalArgumentException("The desired number of splits must be positive or -1 (= don't care).");
        }
        this.numSplits = numSplits;
    }

    public Path getPath() {
        return this.file;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public int hashCode() {
        return this.getSplitNumber() ^ (this.file == null ? 0 : this.file.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileInputSplit && super.equals(obj)) {
            FileInputSplit other = (FileInputSplit)obj;
            return this.start == other.start && this.length == other.length && (this.file == null ? other.file == null : other.file != null && this.file.equals(other.file));
        }
        return false;
    }

    @Override
    public String toString() {
        return "[" + this.getSplitNumber() + "] " + this.file + ":" + this.start + "+" + this.length;
    }

    @Override
    public void configure(Config parameters) {
        this.config = parameters;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void open() throws IOException {
        this.splitStart = this.getStart();
        this.splitLength = this.getLength();
        LOG.log(Level.FINE, "Opening input split " + this.getPath() + " [" + this.splitStart + "," + this.splitLength + "]");
        InputSplitOpenThread isot = new InputSplitOpenThread(this, this.openTimeout);
        isot.start();
        try {
            this.stream = isot.waitForCompletion();
        }
        catch (Throwable t) {
            throw new IOException("Error opening the Input Split " + this.getPath() + " [" + this.splitStart + "," + this.splitLength + "]: " + t.getMessage(), t);
        }
        if (this.splitStart != 0L) {
            this.stream.seek(this.splitStart);
        }
    }

    @Override
    public void open(Config cfg) throws IOException {
        this.splitStart = this.getStart();
        this.splitLength = this.getLength();
        this.config = cfg;
        LOG.log(Level.FINE, "Opening input split " + this.getPath() + " [" + this.splitStart + "," + this.splitLength + "]");
        InputSplitOpenThread isot = new InputSplitOpenThread(this, this.openTimeout, this.config);
        isot.start();
        try {
            this.stream = isot.waitForCompletion();
        }
        catch (Throwable t) {
            throw new IOException("Error opening the Input Split " + this.getPath() + " [" + this.splitStart + "," + this.splitLength + "]: " + t.getMessage(), t);
        }
        if (this.splitStart != 0L) {
            this.stream.seek(this.splitStart);
        }
    }

    public static class InputSplitOpenThread
    extends Thread {
        private final FileInputSplit split;
        private final long timeout;
        private volatile FSDataInputStream fdis;
        private volatile Throwable error;
        private volatile boolean aborted;
        private Config config;

        public InputSplitOpenThread(FileInputSplit split, long timeout) {
            super("Transient InputSplit Opener");
            this.setDaemon(true);
            this.split = split;
            this.timeout = timeout;
        }

        public InputSplitOpenThread(FileInputSplit split, long timeout, Config cfg) {
            super("Transient InputSplit Opener");
            this.setDaemon(true);
            this.split = split;
            this.timeout = timeout;
            this.config = cfg;
        }

        @Override
        public void run() {
            try {
                FileSystem fs = FileSystemUtils.get(this.split.getPath().toUri(), this.config);
                this.fdis = fs.open(this.split.getPath());
                if (this.aborted) {
                    FSDataInputStream f = this.fdis;
                    this.fdis = null;
                    f.close();
                }
            }
            catch (Throwable t) {
                this.error = t;
            }
        }

        public FSDataInputStream waitForCompletion() throws Throwable {
            long start = System.currentTimeMillis();
            long remaining = this.timeout;
            do {
                try {
                    this.join(remaining);
                }
                catch (InterruptedException iex) {
                    this.abortWait();
                    throw iex;
                }
            } while (this.error == null && this.fdis == null && (remaining = this.timeout + start - System.currentTimeMillis()) > 0L);
            if (this.error != null) {
                throw this.error;
            }
            if (this.fdis != null) {
                return this.fdis;
            }
            this.abortWait();
            boolean stillAlive = this.isAlive();
            StringBuilder bld = new StringBuilder(256);
            for (StackTraceElement e : this.getStackTrace()) {
                bld.append("\tat ").append(e.toString()).append('\n');
            }
            throw new IOException("Input opening request timed out. Opener was " + (stillAlive ? "" : "NOT ") + " alive. Stack of split open thread:\n" + bld.toString());
        }

        private void abortWait() {
            this.aborted = true;
            FSDataInputStream inStream = this.fdis;
            this.fdis = null;
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

