/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.api.splits;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.api.splits.DelimitedInputSplit;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Logger;

public class TextInputSplit
extends DelimitedInputSplit<String> {
    private static final Logger LOG = Logger.getLogger(TextInputSplit.class.getName());
    private static final byte CARRIAGE_RETURN = 13;
    private static final byte NEW_LINE = 10;
    private String charsetName = "UTF-8";

    public TextInputSplit(int num, Path file, long start, long length, String[] hosts) {
        super(num, file, start, length, hosts);
    }

    @Override
    public String getCharsetName() {
        return this.charsetName;
    }

    @Override
    public void setCharsetName(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("Charset must not be null.");
        }
        this.charsetName = charsetName;
    }

    @Override
    public void configure(Config parameters) {
        super.configure(parameters);
        if (this.charsetName == null || !Charset.isSupported(this.charsetName)) {
            throw new RuntimeException("Unsupported charset: " + this.charsetName);
        }
    }

    @Override
    public String readRecord(String reusable, byte[] bytes, int readOffset, int numBytes) throws IOException {
        int curNumBytes = numBytes;
        if (this.getDelimiter() != null && this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10 && readOffset + curNumBytes >= 1 && bytes[readOffset + curNumBytes - 1] == 13) {
            --curNumBytes;
        }
        return new String(bytes, readOffset, curNumBytes, this.charsetName);
    }
}

