/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.fs.local;

import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.utils.PreConditions;

public class LocalCSVReader {
    protected boolean[] includedMask;
    protected String lineDelimiter = "\n";
    protected String fieldDelimiter = ",";
    protected String commentPrefix = null;
    protected boolean parseQuotedStrings = false;
    protected char quoteCharacter = (char)34;
    protected boolean skipFirstLineAsHeader = false;
    protected boolean ignoreInvalidLines = false;
    private String charset = "UTF-8";
    private final Path path;

    public Path getFilePath() {
        return this.path;
    }

    public LocalCSVReader(Path filePath) {
        PreConditions.checkNotNull(filePath, "File is not null");
        this.path = filePath;
    }

    public LocalCSVReader lineDelimiter(String delimiter) {
        if (delimiter == null || delimiter.length() == 0) {
            throw new IllegalArgumentException("The delimiter must not be null or an empty string");
        }
        this.lineDelimiter = delimiter;
        return this;
    }

    public LocalCSVReader fieldDelimiter(char delimiter) {
        this.fieldDelimiter = String.valueOf(delimiter);
        return this;
    }

    public LocalCSVReader fieldDelimiter(String delimiter) {
        this.fieldDelimiter = delimiter;
        return this;
    }

    public LocalCSVReader parseQuotedStrings(char quotecharacter) {
        this.parseQuotedStrings = true;
        this.quoteCharacter = quotecharacter;
        return this;
    }

    public LocalCSVReader ignoreComments(String commentprefix) {
        if (this.commentPrefix == null || commentprefix.length() == 0) {
            throw new IllegalArgumentException("The comment prefix must not be null or an empty string");
        }
        this.commentPrefix = commentprefix;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = PreConditions.checkNotNull(charset, "Not null");
    }

    public LocalCSVReader ignoreFirstLine() {
        this.skipFirstLineAsHeader = true;
        return this;
    }

    public LocalCSVReader ignoreInvalidLines() {
        this.ignoreInvalidLines = true;
        return this;
    }
}

