/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.fs.local;

import edu.iu.dsc.tws.api.data.FSDataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.channels.FileChannel;

public class LocalDataInputStream
extends FSDataInputStream {
    private final FileInputStream fis;
    private final FileChannel fileChannel;
    private File fileN;

    public LocalDataInputStream(File file) throws IOException {
        this.fileN = file;
        this.fis = new FileInputStream(file);
        this.fileChannel = this.fis.getChannel();
    }

    public void seek(long desired) throws IOException {
        if (desired != this.getPos()) {
            this.fileChannel.position(desired);
        }
    }

    public long getPos() throws IOException {
        return this.fileChannel.position();
    }

    public int read() throws IOException {
        return this.fis.read();
    }

    public Reader getReader() throws FileNotFoundException {
        return new FileReader(this.fileN);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.fis.read(buffer, offset, length);
    }

    public void close() throws IOException {
        this.fis.close();
    }

    public int available() throws IOException {
        return this.fis.available();
    }

    public long skip(long n) throws IOException {
        return this.fis.skip(n);
    }
}

