/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.fs.local;

import edu.iu.dsc.tws.api.data.FSDataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class LocalDataOutputStream
extends FSDataOutputStream {
    private final FileOutputStream fos;

    public LocalDataOutputStream(File file) throws IOException {
        this.fos = new FileOutputStream(file);
    }

    public void write(int b) throws IOException {
        this.fos.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.fos.write(b, off, len);
    }

    public void close() throws IOException {
        this.fos.close();
    }

    public void write(ByteBuffer byteBuffer) throws IOException {
        this.fos.getChannel().write(byteBuffer);
    }

    public void flush() throws IOException {
        this.fos.flush();
    }

    public void sync() throws IOException {
        this.fos.getFD().sync();
    }

    public long getPos() throws IOException {
        return this.fos.getChannel().position();
    }

    public FileChannel getChannel() {
        return this.fos.getChannel();
    }
}

