/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.fs.local;

import edu.iu.dsc.tws.api.data.FileStatus;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import java.io.File;

public class LocalFileStatus
implements FileStatus {
    private final File file;
    private final Path path;

    public LocalFileStatus(File f, FileSystem fs) {
        this.file = f;
        this.path = new Path(fs.getUri().getScheme() + ":" + f.toURI().getPath());
    }

    public long getAccessTime() {
        return 0L;
    }

    public long getBlockSize() {
        return this.file.length();
    }

    public long getLen() {
        return this.file.length();
    }

    public long getModificationTime() {
        return this.file.lastModified();
    }

    public short getReplication() {
        return 1;
    }

    public boolean isDir() {
        return this.file.isDirectory();
    }

    public Path getPath() {
        return this.path;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return "LocalFileStatus{file=" + this.file + ", path=" + this.path + '}';
    }
}

