/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.fs.local;

import edu.iu.dsc.tws.api.data.BlockLocation;
import edu.iu.dsc.tws.api.data.FSDataInputStream;
import edu.iu.dsc.tws.api.data.FSDataOutputStream;
import edu.iu.dsc.tws.api.data.FileStatus;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.fs.local.LocalBlockLocation;
import edu.iu.dsc.tws.data.fs.local.LocalDataInputStream;
import edu.iu.dsc.tws.data.fs.local.LocalDataOutputStream;
import edu.iu.dsc.tws.data.fs.local.LocalFileStatus;
import edu.iu.dsc.tws.data.utils.OperatingSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.FileAlreadyExistsException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalFileSystem
extends FileSystem {
    private static final Logger LOG = Logger.getLogger(LocalFileSystem.class.getName());
    private static URI uri = OperatingSystem.isWindows() ? URI.create("file:/") : URI.create("file:///");
    private final String workingDir = new Path(System.getProperty("user.dir")).makeQualified((FileSystem)this).toString();
    private final String homeDir = new Path(System.getProperty("user.home")).toString();
    private final String hostName;

    public LocalFileSystem() {
        String tmp = "unknownHost";
        try {
            tmp = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Could not resolve local host", e);
        }
        this.hostName = tmp;
    }

    public void setWorkingDirectory(Path path) {
    }

    public Path getWorkingDirectory() {
        return null;
    }

    public URI getUri() {
        return uri;
    }

    public void initialize(URI name) throws IOException {
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        File path = this.pathToFile(f);
        if (path.exists()) {
            return new LocalFileStatus(this.pathToFile(f), this);
        }
        throw new FileNotFoundException("input file does not exist in the user specified directory " + f + " or the user running Twister2 ('" + System.getProperty("user.name") + "') has insufficient permissions to access it.");
    }

    public FileStatus[] listFiles(Path f) throws IOException {
        File localf = this.pathToFile(f);
        if (!localf.exists()) {
            return null;
        }
        if (localf.isFile()) {
            return new FileStatus[]{new LocalFileStatus(localf, this)};
        }
        String[] names = localf.list();
        if (names == null) {
            return null;
        }
        FileStatus[] results = new FileStatus[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = this.getFileStatus(new Path(f, names[i]));
        }
        return results;
    }

    public FSDataInputStream open(Path f) throws IOException {
        File file = this.pathToFile(f);
        return new LocalDataInputStream(file);
    }

    private File pathToFile(Path path) {
        Path curPath = path;
        if (!path.isAbsolute()) {
            curPath = new Path(this.getWorkingDirectory(), path);
        }
        return new File(curPath.toUri().getPath());
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return new BlockLocation[]{new LocalBlockLocation(this.hostName, file.getLen())};
    }

    private File pathToFile(Path path, int bufferSize) {
        Path curPath = path;
        if (!path.isAbsolute()) {
            curPath = new Path(this.getWorkingDirectory(), path);
        }
        return new File(curPath.toUri().getPath(), String.valueOf(bufferSize));
    }

    public FSDataInputStream open(Path path, int bufferSize) throws IOException {
        Path directoryPath = path;
        File file = this.pathToFile(directoryPath, bufferSize);
        return new LocalDataInputStream(file);
    }

    public FSDataOutputStream create(Path filePath) throws IOException {
        Path parent = filePath.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent);
        }
        File file = this.pathToFile(filePath);
        return new LocalDataOutputStream(file);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        File file = this.pathToFile(f);
        if (file.isFile()) {
            return file.delete();
        }
        if (!recursive && file.isDirectory()) {
            File[] containedFiles = file.listFiles();
            if (containedFiles == null) {
                throw new IOException("Directory " + file.toString() + " does not exist or an I/O error occurred");
            }
            if (containedFiles.length != 0) {
                throw new IOException("Directory " + file.toString() + " is not empty");
            }
        }
        return this.delete(file);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        return new FileStatus[0];
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.mkdirsInternal(this.pathToFile(f));
    }

    private boolean mkdirsInternal(File file) throws IOException {
        if (file.isDirectory()) {
            return true;
        }
        if (file.exists() && !file.isDirectory()) {
            throw new FileAlreadyExistsException(file.getAbsolutePath());
        }
        File parent = file.getParentFile();
        return (parent == null || this.mkdirsInternal(parent)) && file.mkdir();
    }

    public boolean exists(Path path) throws IOException {
        File f = new File(path.getPath());
        return f.exists();
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return false;
    }

    public long getDefaultBlockSize() {
        return 0L;
    }

    public boolean isDistributedFS() {
        return false;
    }

    private boolean delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (File file : files) {
                    boolean del = this.delete(file);
                    if (del) continue;
                    return false;
                }
            }
        } else {
            return f.delete();
        }
        return f.delete();
    }
}

