/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.hdfs;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.BlockLocation;

public final class HadoopBlockLocation
implements edu.iu.dsc.tws.api.data.BlockLocation {
    private static final char DOMAIN_SEPARATOR = '.';
    private static final Pattern IPV4_PATTERN = Pattern.compile("^\\d+\\.\\d+\\.\\d+\\.\\d+$");
    private final BlockLocation blockLocation;
    private String[] hostnames;

    public HadoopBlockLocation(BlockLocation blocklocation) {
        this.blockLocation = blocklocation;
    }

    public String[] getHosts() throws IOException {
        if (this.hostnames == null) {
            String[] hadoopHostnames = this.blockLocation.getHosts();
            this.hostnames = new String[hadoopHostnames.length];
            for (int i = 0; i < hadoopHostnames.length; ++i) {
                this.hostnames[i] = HadoopBlockLocation.stripHostname(hadoopHostnames[i]);
            }
        }
        return this.hostnames;
    }

    public long getLength() {
        return this.blockLocation.getLength();
    }

    public long getOffset() {
        return this.blockLocation.getOffset();
    }

    public int compareTo(edu.iu.dsc.tws.api.data.BlockLocation o) {
        long diff = this.getOffset() - o.getOffset();
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    private static String stripHostname(String originalHostname) {
        int index = originalHostname.indexOf(46);
        if (index == -1) {
            return originalHostname;
        }
        Matcher matcher = IPV4_PATTERN.matcher(originalHostname);
        if (matcher.matches()) {
            return originalHostname;
        }
        if (index == 0) {
            throw new IllegalStateException("Hostname " + originalHostname + " starts with a " + '.');
        }
        return originalHostname.substring(0, index);
    }
}

