/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.hdfs;

import edu.iu.dsc.tws.api.data.FSDataInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public final class HadoopDataInputStream
extends FSDataInputStream {
    private static final Logger LOG = Logger.getLogger(HadoopDataInputStream.class.getName());
    public static final int MIN_SKIP_BYTES = 0x100000;
    private final org.apache.hadoop.fs.FSDataInputStream fosInputStream;

    public HadoopDataInputStream(org.apache.hadoop.fs.FSDataInputStream dataInputStream) {
        this.fosInputStream = dataInputStream;
    }

    public void seek(long seekPosition) throws IOException {
        long delta = seekPosition - this.getPos();
        if (delta > 0L && delta <= 0x100000L) {
            this.skipFully(delta);
        } else if (delta != 0L) {
            this.forceSeek(seekPosition);
        }
    }

    public long getPos() throws IOException {
        return this.fosInputStream.getPos();
    }

    public Reader getReader() {
        return null;
    }

    public int read() throws IOException {
        return this.fosInputStream.read();
    }

    public void close() throws IOException {
        this.fosInputStream.close();
    }

    public int read(@Nonnull byte[] buffer, int offset, int length) throws IOException {
        return this.fosInputStream.read(buffer, offset, length);
    }

    public int available() throws IOException {
        return this.fosInputStream.available();
    }

    public long skip(long n) throws IOException {
        return this.fosInputStream.skip(n);
    }

    public org.apache.hadoop.fs.FSDataInputStream getHadoopInputStream() {
        return this.fosInputStream;
    }

    public void forceSeek(long seekPos) throws IOException {
        this.fosInputStream.seek(seekPos);
    }

    public void skipFully(long bytes) throws IOException {
    }
}

