/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.hdfs;

import edu.iu.dsc.tws.api.data.FileStatus;
import edu.iu.dsc.tws.api.data.FileSystem;
import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.data.hdfs.HadoopBlockLocation;
import edu.iu.dsc.tws.data.hdfs.HadoopDataInputStream;
import edu.iu.dsc.tws.data.hdfs.HadoopDataOutputStream;
import edu.iu.dsc.tws.data.hdfs.HadoopFileStatus;
import edu.iu.dsc.tws.data.utils.PreConditions;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;

public class HadoopFileSystem
extends FileSystem
implements Closeable {
    private static final Logger LOG = Logger.getLogger(HadoopFileSystem.class.getName());
    private Configuration conf;
    private org.apache.hadoop.fs.FileSystem hadoopFileSystem;

    public HadoopFileSystem(Configuration hadoopConfig, org.apache.hadoop.fs.FileSystem hadoopfileSystem) {
        this.conf = PreConditions.checkNotNull(hadoopConfig, "hadoopConfig");
        this.hadoopFileSystem = PreConditions.checkNotNull(hadoopfileSystem, "fileSystem");
    }

    private static Class<? extends FileSystem> getFileSystemByName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, FileSystem.class.getClassLoader()).asSubclass(FileSystem.class);
    }

    private static org.apache.hadoop.fs.Path toHadoopPath(Path path) {
        return new org.apache.hadoop.fs.Path(path.toUri());
    }

    public org.apache.hadoop.fs.FileSystem getHadoopFileSystem() {
        return this.hadoopFileSystem;
    }

    private Configuration getHadoopConfiguration() {
        return new Configuration();
    }

    public Path getWorkingDirectory() {
        return new Path(this.hadoopFileSystem.getWorkingDirectory().toUri());
    }

    public void setWorkingDirectory(Path path1) {
    }

    public URI getUri() {
        return this.hadoopFileSystem.getUri();
    }

    public void initialize(URI name) {
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus status = this.hadoopFileSystem.getFileStatus(HadoopFileSystem.toHadoopPath(f));
        FileStatus[] fileStatuses = this.listStatus(f);
        return fileStatuses[0];
    }

    public edu.iu.dsc.tws.api.data.BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!(file instanceof HadoopFileStatus)) {
            throw new IOException("file is not an instance of DistributedFileStatus");
        }
        HadoopFileStatus f = (HadoopFileStatus)file;
        BlockLocation[] blkLocations = this.hadoopFileSystem.getFileBlockLocations(f.getInternalFileStatus(), start, len);
        edu.iu.dsc.tws.api.data.BlockLocation[] distBlkLocations = new HadoopBlockLocation[blkLocations.length];
        for (int i = 0; i < distBlkLocations.length; ++i) {
            distBlkLocations[i] = new HadoopBlockLocation(blkLocations[i]);
        }
        return distBlkLocations;
    }

    public HadoopDataInputStream open(Path f, int bufferSize) throws IOException {
        org.apache.hadoop.fs.Path directoryPath = HadoopFileSystem.toHadoopPath(f);
        FSDataInputStream fsDataInputStream = this.hadoopFileSystem.open(directoryPath, bufferSize);
        return new HadoopDataInputStream(fsDataInputStream);
    }

    public HadoopDataInputStream open(Path f) throws IOException {
        FSDataInputStream fsDataInputStream = this.hadoopFileSystem.open(HadoopFileSystem.toHadoopPath(f));
        return new HadoopDataInputStream(fsDataInputStream);
    }

    public HadoopDataOutputStream create(Path f) throws IOException {
        FSDataOutputStream fsDataOutputStream = this.hadoopFileSystem.create(HadoopFileSystem.toHadoopPath(f));
        return new HadoopDataOutputStream(fsDataOutputStream);
    }

    public HadoopDataOutputStream append(Path path) throws IOException {
        FSDataOutputStream fsDataOutputStream = this.hadoopFileSystem.append(HadoopFileSystem.toHadoopPath(path));
        return new HadoopDataOutputStream(fsDataOutputStream);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.hadoopFileSystem.delete(HadoopFileSystem.toHadoopPath(f), recursive);
    }

    public boolean exists(Path f) throws IOException {
        return this.hadoopFileSystem.exists(HadoopFileSystem.toHadoopPath(f));
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus[] hadoopFiles = this.hadoopFileSystem.listStatus(HadoopFileSystem.toHadoopPath(f));
        FileStatus[] files = new FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new HadoopFileStatus(hadoopFiles[i]);
        }
        return files;
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.hadoopFileSystem.mkdirs(HadoopFileSystem.toHadoopPath(f));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.hadoopFileSystem.rename(HadoopFileSystem.toHadoopPath(src), HadoopFileSystem.toHadoopPath(dst));
    }

    public long getDefaultBlockSize() {
        return this.hadoopFileSystem.getDefaultBlockSize();
    }

    public boolean isDistributedFS() {
        return true;
    }

    public FileStatus[] listFiles(Path f) {
        return new FileStatus[0];
    }

    @Override
    public void close() throws IOException {
        this.hadoopFileSystem.close();
    }
}

