/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.memory;

import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.api.util.KryoSerializer;
import edu.iu.dsc.tws.data.memory.AbstractMemoryManager;
import edu.iu.dsc.tws.data.memory.MemoryManager;
import edu.iu.dsc.tws.data.memory.MemoryManagerContext;
import edu.iu.dsc.tws.data.memory.OperationMemoryManager;
import edu.iu.dsc.tws.data.memory.lmdb.LMDBMemoryManager;
import edu.iu.dsc.tws.data.memory.utils.DataMessageType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class BufferedMemoryManager
extends AbstractMemoryManager {
    private static final Logger LOG = Logger.getLogger(BufferedMemoryManager.class.getName());
    private MemoryManager memoryManager;
    private Map<Integer, Map<String, Integer>> keyMap;
    private Map<Integer, Map<String, Integer>> keyMapCurrent;
    private Map<Integer, Map<String, LinkedList<ByteBuffer>>> keyMapBuffers;
    private Map<Integer, Map<String, Integer>> keyBufferSizes;

    public BufferedMemoryManager(Path dataPath) {
        this.memoryManager = new LMDBMemoryManager(dataPath);
        this.init();
    }

    @Override
    public boolean init() {
        this.keyMap = new HashMap<Integer, Map<String, Integer>>();
        this.keyMapCurrent = new HashMap<Integer, Map<String, Integer>>();
        this.keyMapBuffers = new HashMap<Integer, Map<String, LinkedList<ByteBuffer>>>();
        this.keyBufferSizes = new HashMap<Integer, Map<String, Integer>>();
        this.operationMap = new HashMap();
        return false;
    }

    @Override
    public boolean append(int opID, ByteBuffer key, ByteBuffer value) {
        if (key.position() != 0) {
            key.flip();
        }
        String keyString = MemoryManagerContext.DEFAULT_CHARSET.decode(key).toString();
        return this.appendBulk(opID, keyString, value);
    }

    @Override
    public boolean append(int opID, String key, ByteBuffer value) {
        return this.appendBulk(opID, key, value);
    }

    @Override
    public boolean put(int opID, ByteBuffer key, ByteBuffer value) {
        if (key.position() != 0) {
            key.flip();
        }
        String keyString = MemoryManagerContext.DEFAULT_CHARSET.decode(key).toString();
        return this.putBulk(opID, keyString, value);
    }

    @Override
    public boolean put(int opID, byte[] key, byte[] data) {
        return false;
    }

    @Override
    public boolean put(int opID, String key, ByteBuffer value) {
        return this.putBulk(opID, key, value);
    }

    @Override
    public ByteBuffer get(int opID, ByteBuffer key) {
        if (key.position() != 0) {
            key.flip();
        }
        String keyString = MemoryManagerContext.DEFAULT_CHARSET.decode(key).toString();
        if (this.keyMap.get(opID).containsKey(keyString)) {
            this.flush(opID, keyString);
        }
        return this.memoryManager.get(opID, key);
    }

    @Override
    public ByteBuffer get(int opID, String key) {
        if (this.keyMap.get(opID).containsKey(key)) {
            this.flush(opID, key);
        }
        return this.memoryManager.get(opID, key);
    }

    @Override
    public boolean containsKey(int opID, ByteBuffer key) {
        if (key.position() != 0) {
            key.flip();
        }
        return this.containsKey(opID, MemoryManagerContext.DEFAULT_CHARSET.decode(key).toString());
    }

    @Override
    public boolean containsKey(int opID, String key) {
        if (this.keyMap.get(opID).containsKey(key)) {
            return true;
        }
        return this.memoryManager.containsKey(opID, key);
    }

    @Override
    public boolean delete(int opID, ByteBuffer key) {
        if (key.position() != 0) {
            key.flip();
        }
        this.deleteFromBMM(opID, MemoryManagerContext.DEFAULT_CHARSET.decode(key).toString());
        return this.memoryManager.delete(opID, key);
    }

    @Override
    public boolean delete(int opID, String key) {
        this.deleteFromBMM(opID, key);
        return this.memoryManager.delete(opID, key);
    }

    public void deleteFromBMM(int opID, String key) {
        this.keyMap.get(opID).remove(key);
        this.keyMapCurrent.get(opID).remove(key);
        this.keyMapBuffers.get(opID).remove(key);
        this.keyBufferSizes.get(opID).remove(key);
    }

    @Override
    public OperationMemoryManager addOperation(int opID, DataMessageType type) {
        if (this.operationMap.containsKey(opID)) {
            return null;
        }
        OperationMemoryManager temp = new OperationMemoryManager(opID, type, this);
        this.memoryManager.addOperation(opID, type);
        this.keyMap.put(opID, new ConcurrentHashMap());
        this.keyMapCurrent.put(opID, new ConcurrentHashMap());
        this.keyMapBuffers.put(opID, new ConcurrentHashMap());
        this.keyBufferSizes.put(opID, new ConcurrentHashMap());
        this.operationMap.put(opID, temp);
        return temp;
    }

    @Override
    public OperationMemoryManager addOperation(int opID, DataMessageType type, DataMessageType keyType) {
        if (this.operationMap.containsKey(opID)) {
            return null;
        }
        OperationMemoryManager temp = new OperationMemoryManager(opID, type, keyType, this);
        this.memoryManager.addOperation(opID, keyType, type);
        this.keyMap.put(opID, new ConcurrentHashMap());
        this.keyMapCurrent.put(opID, new ConcurrentHashMap());
        this.keyMapBuffers.put(opID, new ConcurrentHashMap());
        this.keyBufferSizes.put(opID, new ConcurrentHashMap());
        this.operationMap.put(opID, temp);
        return temp;
    }

    @Override
    public boolean removeOperation(int opID) {
        this.memoryManager.removeOperation(opID);
        this.keyMap.remove(opID);
        this.keyMapCurrent.remove(opID);
        this.keyMapBuffers.remove(opID);
        this.keyBufferSizes.remove(opID);
        this.operationMap.remove(opID);
        return true;
    }

    public boolean registerKey(int opID, String key, int step) {
        if (this.keyMap.get(opID).containsKey(key)) {
            return false;
        }
        this.keyMap.get(opID).put(key, step);
        this.keyMapCurrent.get(opID).put(key, 0);
        this.keyMapBuffers.get(opID).put(key, new LinkedList());
        this.keyBufferSizes.get(opID).put(key, 0);
        return true;
    }

    public boolean registerKey(int opID, String key) {
        return this.registerKey(opID, key, 10);
    }

    public boolean putBulk(int opID, String key, ByteBuffer value) {
        if (value.position() != 0) {
            value.flip();
        }
        if (!this.keyMap.get(opID).containsKey(key) && !this.memoryManager.containsKey(opID, key)) {
            this.registerKey(opID, key, 10);
        } else {
            this.delete(opID, key);
            this.registerKey(opID, key, 10);
        }
        this.keyMapCurrent.get(opID).put(key, 1);
        this.keyMapBuffers.get(opID).get(key).add(value);
        this.keyBufferSizes.get(opID).put(key, this.keyBufferSizes.get(opID).get(key) + value.limit());
        return true;
    }

    public boolean appendBulk(int opID, String key, ByteBuffer value) {
        if (value.position() != 0) {
            value.flip();
        }
        if (!this.keyMap.get(opID).containsKey(key)) {
            this.registerKey(opID, key, 10);
        }
        int step = this.keyMap.get(opID).get(key);
        int currentCount = this.keyMapCurrent.get(opID).get(key);
        if ((currentCount + 1) % step == 0) {
            this.flush(opID, key, value);
            this.keyMapCurrent.get(opID).put(key, currentCount + 1);
        } else {
            this.keyMapCurrent.get(opID).put(key, currentCount + 1);
            this.keyMapBuffers.get(opID).get(key).add(value);
            this.keyBufferSizes.get(opID).put(key, this.keyBufferSizes.get(opID).get(key) + value.limit());
        }
        return true;
    }

    @Override
    public boolean flush(int opID, ByteBuffer key) {
        if (key.position() != 0) {
            key.flip();
        }
        return this.flush(opID, MemoryManagerContext.DEFAULT_CHARSET.decode(key).toString());
    }

    @Override
    public boolean flush(int opID, String key) {
        ByteBuffer temp = ByteBuffer.allocateDirect(this.keyBufferSizes.get(opID).get(key));
        LinkedList<ByteBuffer> buffers = this.keyMapBuffers.get(opID).get(key);
        while (!buffers.isEmpty()) {
            temp.put(buffers.poll());
        }
        this.keyMap.get(opID).remove(key);
        this.keyMapCurrent.get(opID).remove(key);
        this.keyMapBuffers.get(opID).remove(key);
        this.keyBufferSizes.get(opID).remove(key);
        if (this.memoryManager.containsKey(opID, key)) {
            return this.memoryManager.append(opID, key, temp);
        }
        return this.memoryManager.put(opID, key, temp);
    }

    @Override
    public boolean flush(int opID) {
        return false;
    }

    public boolean flush(int opID, String key, ByteBuffer last) {
        ByteBuffer temp = ByteBuffer.allocateDirect(this.keyBufferSizes.get(opID).get(key) + last.limit());
        LinkedList<ByteBuffer> buffers = this.keyMapBuffers.get(opID).get(key);
        while (!buffers.isEmpty()) {
            temp.put(buffers.poll());
        }
        temp.put(last);
        this.keyMap.get(opID).remove(key);
        this.keyMapCurrent.get(opID).remove(key);
        this.keyMapBuffers.get(opID).remove(key);
        this.keyBufferSizes.get(opID).remove(key);
        if (this.memoryManager.containsKey(opID, key)) {
            return this.memoryManager.append(opID, key, temp);
        }
        return this.memoryManager.put(opID, key, temp);
    }

    public boolean flushAll(int opID) {
        for (String s : this.keyMap.get(opID).keySet()) {
            this.flush(opID, s);
        }
        return true;
    }

    @Override
    public boolean close(int opID, ByteBuffer key) {
        if (key.position() != 0) {
            key.flip();
        }
        return this.close(opID, MemoryManagerContext.DEFAULT_CHARSET.decode(key).toString());
    }

    @Override
    public boolean close(int opID, String key) {
        this.flush(opID, key);
        this.keyMap.get(opID).remove(key);
        this.keyMapCurrent.get(opID).remove(key);
        this.keyMapBuffers.get(opID).remove(key);
        this.keyBufferSizes.get(opID).remove(key);
        return true;
    }

    @Override
    public Iterator<Object> getIterator(int opID, DataMessageType keyType, DataMessageType valueType, KryoSerializer deSerializer, ByteOrder order) {
        this.flushAll(opID);
        return this.memoryManager.getIterator(opID, keyType, valueType, deSerializer, order);
    }

    @Override
    public Iterator<Object> getIterator(int opID, DataMessageType valueType, KryoSerializer deSerializer, ByteOrder order) {
        this.flushAll(opID);
        return this.memoryManager.getIterator(opID, valueType, deSerializer, order);
    }
}

