/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.memory;

import edu.iu.dsc.tws.api.util.KryoSerializer;
import edu.iu.dsc.tws.data.memory.MemoryManager;
import edu.iu.dsc.tws.data.memory.utils.DataMessageType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;

public class OperationMemoryManager {
    private int operationID;
    private MemoryManager memoryManager;
    private boolean isKeyed;
    private DataMessageType keyType;
    private DataMessageType messageType;
    private KryoSerializer deSerializer;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public OperationMemoryManager(int opID, DataMessageType type, MemoryManager parentMM) {
        this.operationID = opID;
        this.memoryManager = parentMM;
        this.messageType = type;
        this.deSerializer = new KryoSerializer();
        this.isKeyed = false;
        this.init();
    }

    public OperationMemoryManager(int opID, DataMessageType type, DataMessageType keyType, MemoryManager parentMM) {
        this.operationID = opID;
        this.memoryManager = parentMM;
        this.messageType = type;
        this.keyType = keyType;
        this.deSerializer = new KryoSerializer();
        this.isKeyed = true;
        this.init();
    }

    public boolean init() {
        return true;
    }

    public boolean append(ByteBuffer key, ByteBuffer value) {
        return this.memoryManager.append(this.operationID, key, value);
    }

    public boolean append(String key, ByteBuffer value) {
        return this.memoryManager.append(this.operationID, key, value);
    }

    public boolean put(ByteBuffer key, ByteBuffer value) {
        return this.memoryManager.put(this.operationID, key, value);
    }

    public boolean put(byte[] key, byte[] data) {
        return this.memoryManager.put(this.operationID, key, data);
    }

    public boolean put(String key, ByteBuffer value) {
        return this.memoryManager.put(this.operationID, key, value);
    }

    public ByteBuffer get(ByteBuffer key) {
        return this.memoryManager.get(this.operationID, key);
    }

    public ByteBuffer get(String key) {
        return this.memoryManager.get(this.operationID, key);
    }

    public boolean containsKey(ByteBuffer key) {
        return this.memoryManager.containsKey(this.operationID, key);
    }

    public boolean containsKey(String key) {
        return this.memoryManager.containsKey(this.operationID, key);
    }

    public boolean delete(ByteBuffer key) {
        return this.memoryManager.delete(this.operationID, key);
    }

    public boolean delete(String key) {
        return this.memoryManager.delete(this.operationID, key);
    }

    public boolean flush(ByteBuffer key) {
        return this.memoryManager.flush(this.operationID, key);
    }

    public boolean flush() {
        return this.memoryManager.flush(this.operationID);
    }

    public boolean flush(String key) {
        return this.memoryManager.flush(this.operationID, key);
    }

    public boolean close(ByteBuffer key) {
        return this.memoryManager.close(this.operationID, key);
    }

    public boolean close(String key) {
        return this.memoryManager.close(this.operationID, key);
    }

    public int getOperationID() {
        return this.operationID;
    }

    public void setOperationID(int operationID) {
        this.operationID = operationID;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public void setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    public Iterator<Object> iterator() {
        if (this.isKeyed) {
            return this.memoryManager.getIterator(this.operationID, this.keyType, this.messageType, this.deSerializer, this.byteOrder);
        }
        return this.memoryManager.getIterator(this.operationID, this.messageType, this.deSerializer, this.byteOrder);
    }

    public Iterator<Object> iterator(ByteOrder order) {
        if (this.isKeyed) {
            return this.memoryManager.getIterator(this.operationID, this.keyType, this.messageType, this.deSerializer, order);
        }
        return this.memoryManager.getIterator(this.operationID, this.messageType, this.deSerializer, order);
    }

    public DataMessageType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(DataMessageType keyType) {
        this.keyType = keyType;
    }

    public DataMessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(DataMessageType messageType) {
        this.messageType = messageType;
    }

    public boolean isKeyed() {
        return this.isKeyed;
    }

    public void setKeyed(boolean keyed) {
        this.isKeyed = keyed;
    }
}

