/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.memory.lmdb;

import edu.iu.dsc.tws.data.memory.lmdb.LMDBMemoryManager;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.lang3.tuple.Pair;
import org.lmdbjava.Cursor;
import org.lmdbjava.Dbi;
import org.lmdbjava.Env;
import org.lmdbjava.PutFlags;
import org.lmdbjava.Txn;

public class LMDBDataWriter
implements Runnable {
    private ByteBuffer keyBuffer;
    private ByteBuffer dataBuffer;
    private int currentDbiCount;
    private Env<ByteBuffer> envRef;
    private Map<Integer, Dbi<ByteBuffer>> dbMapRef;
    private Map<Integer, LinkedBlockingDeque<Pair<byte[], byte[]>>> dataQueueMapRef;

    public LMDBDataWriter(Map<Integer, Dbi<ByteBuffer>> dbMap, Map<Integer, LinkedBlockingDeque<Pair<byte[], byte[]>>> dataQueueMap, Env<ByteBuffer> env) {
        this.dbMapRef = dbMap;
        this.dataQueueMapRef = dataQueueMap;
        this.envRef = env;
        this.keyBuffer = ByteBuffer.allocateDirect(16);
        this.dataBuffer = ByteBuffer.allocateDirect(128);
        this.currentDbiCount = 0;
    }

    @Override
    public void run() {
        Txn writeTxn = null;
        HashMap openCoursors = new HashMap();
        ArrayList opIDs = new ArrayList();
        int opID = 0;
        Cursor c = null;
        int count = 0;
        while (this.currentDbiCount == 0) {
            if (this.dbMapRef.size() <= 0 || this.dataQueueMapRef.size() <= 0) continue;
            writeTxn = this.envRef.txnWrite();
            for (Map.Entry<Integer, Dbi<ByteBuffer>> dbiEntry : this.dbMapRef.entrySet()) {
                opID = dbiEntry.getKey();
                c = dbiEntry.getValue().openCursor(writeTxn);
                ++this.currentDbiCount;
            }
        }
        Pair<byte[], byte[]> tempPair = null;
        LinkedBlockingDeque<Pair<byte[], byte[]>> dataQueue = this.dataQueueMapRef.get(opID);
        while (true) {
            if ((tempPair = dataQueue.poll()) != null) {
                this.setupThreadLocalBuffers(((byte[])tempPair.getKey()).length, ((byte[])tempPair.getValue()).length);
                this.keyBuffer.put((byte[])tempPair.getKey());
                this.keyBuffer.flip();
                this.dataBuffer.putInt(((byte[])tempPair.getValue()).length);
                this.dataBuffer.put((byte[])tempPair.getValue());
                this.dataBuffer.flip();
                c.put((Object)this.keyBuffer, (Object)this.dataBuffer, new PutFlags[0]);
                LMDBMemoryManager.needsCommitWriter = true;
                if (++count % 2000000 == 0 && count > 0) {
                    writeTxn.commit();
                    writeTxn.close();
                    writeTxn = this.envRef.txnWrite();
                    c = this.dbMapRef.get(opID).openCursor(writeTxn);
                    LMDBMemoryManager.needsCommitWriter = false;
                    LMDBMemoryManager.needsCommitReader = false;
                    System.out.println("added 2  mil to mm");
                }
            }
            if (!LMDBMemoryManager.needsCommitReader.booleanValue()) continue;
            writeTxn.commit();
            writeTxn.close();
            writeTxn = this.envRef.txnWrite();
            c = this.dbMapRef.get(opID).openCursor(writeTxn);
            LMDBMemoryManager.needsCommitWriter = false;
            LMDBMemoryManager.needsCommitReader = false;
        }
    }

    private void setupThreadLocalBuffers(int keyLength, int dataLength) {
        int dataLengthTemp = dataLength + 4;
        if (this.keyBuffer.capacity() < keyLength) {
            this.keyBuffer = ByteBuffer.allocateDirect(keyLength);
        }
        if (this.dataBuffer.capacity() < dataLengthTemp) {
            this.dataBuffer = ByteBuffer.allocateDirect(dataLengthTemp);
        }
        this.dataBuffer.clear();
        this.keyBuffer.clear();
    }
}

