/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.data.memory.lmdb;

import edu.iu.dsc.tws.api.data.Path;
import edu.iu.dsc.tws.api.util.KryoSerializer;
import edu.iu.dsc.tws.data.memory.AbstractMemoryManager;
import edu.iu.dsc.tws.data.memory.MemoryManagerContext;
import edu.iu.dsc.tws.data.memory.OperationMemoryManager;
import edu.iu.dsc.tws.data.memory.lmdb.LMDBDataWriter;
import edu.iu.dsc.tws.data.memory.utils.DataMessageType;
import edu.iu.dsc.tws.data.utils.MemoryDeserializer;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lmdbjava.CursorIterator;
import org.lmdbjava.Dbi;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.Env;
import org.lmdbjava.EnvFlags;
import org.lmdbjava.KeyRange;
import org.lmdbjava.Txn;

public class LMDBMemoryManager
extends AbstractMemoryManager {
    private static final Logger LOG = Logger.getLogger(LMDBMemoryManager.class.getName());
    private Path lmdbDataPath;
    private Env<ByteBuffer> env;
    private Dbi<ByteBuffer> db;
    private Map<Integer, Dbi<ByteBuffer>> dbMap;
    private Map<Integer, LinkedBlockingDeque<Pair<byte[], byte[]>>> dataQueueMap;
    protected Lock lock = new ReentrantLock();
    private ByteBuffer keyBuffer;
    private ByteBuffer dataBuffer;
    protected static Boolean needsCommitWriter;
    protected static Boolean needsCommitReader;
    private Stack<Txn<ByteBuffer>> readTxns;
    private ThreadLocal<Txn<ByteBuffer>> threadReadTxn;
    private ThreadLocal<ByteBuffer> threadappendBuffer;

    public LMDBMemoryManager(Path dataPath) {
        this.lmdbDataPath = dataPath;
        this.init();
    }

    @Override
    public boolean init() {
        try {
            File path;
            if (this.lmdbDataPath == null || this.lmdbDataPath.isNullOrEmpty()) {
                this.lmdbDataPath = new Path("\tmp\twister2lmdb");
            }
            if (!(path = new File(this.lmdbDataPath.getPath())).exists()) {
                path.mkdirs();
            }
            EnvFlags[] envFlags = LMDBMemoryManager.envFlags(true, false);
            this.env = Env.create().setMapSize(0x140000000L).setMaxDbs(10).setMaxReaders(128).open(path, envFlags);
            this.db = this.env.openDbi("default_twister2_lmdb", new DbiFlags[]{DbiFlags.MDB_CREATE});
            this.dbMap = new HashMap<Integer, Dbi<ByteBuffer>>();
            this.keyBuffer = ByteBuffer.allocateDirect(16);
            this.dataBuffer = ByteBuffer.allocateDirect(128);
            this.dataQueueMap = new HashMap<Integer, LinkedBlockingDeque<Pair<byte[], byte[]>>>();
            needsCommitReader = false;
            needsCommitWriter = true;
            Thread writerThread = new Thread(new LMDBDataWriter(this.dbMap, this.dataQueueMap, this.env));
            writerThread.start();
            this.threadReadTxn = new ThreadLocal();
            this.threadappendBuffer = new ThreadLocal();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error while creating LMDB database at Path " + this.lmdbDataPath.toString(), e);
        }
        return true;
    }

    @Override
    public ByteBuffer get(int opID, ByteBuffer key) {
        if (!this.dbMap.containsKey(opID)) {
            LOG.info("The given operation does not have a corresponding store specified");
            return null;
        }
        Dbi<ByteBuffer> currentDB = this.dbMap.get(opID);
        if (key.position() != 0) {
            key.flip();
        }
        if (key.limit() > 511) {
            LOG.info("Key size lager than 511 bytes which is the limit for LMDB key values");
            return null;
        }
        if (this.threadReadTxn.get() == null) {
            this.threadReadTxn.set((Txn<ByteBuffer>)this.env.txnRead());
        }
        Txn<ByteBuffer> txn = this.threadReadTxn.get();
        txn.reset();
        txn.renew();
        ByteBuffer result = (ByteBuffer)currentDB.get(txn, (Object)key);
        return result;
    }

    @Override
    public ByteBuffer get(int opID, String key) {
        ByteBuffer temp = MemoryManagerContext.DEFAULT_CHARSET.encode(key);
        ByteBuffer keyBuffertemp = ByteBuffer.allocateDirect(temp.limit());
        keyBuffertemp.put(temp);
        return this.get(opID, keyBuffertemp);
    }

    public ByteBuffer getAll(ByteBuffer key) {
        if (key.position() != 0) {
            key.flip();
        }
        if (key.limit() > 511) {
            LOG.info("Key size lager than 511 bytes which is the limit for LMDB key values");
            return null;
        }
        return null;
    }

    @Override
    public boolean containsKey(int opID, ByteBuffer key) {
        if (!this.dbMap.containsKey(opID)) {
            LOG.info("The given operation does not have a corresponding store specified");
            return false;
        }
        if (key.position() != 0) {
            key.flip();
        }
        Dbi<ByteBuffer> currentDB = this.dbMap.get(opID);
        if (key.limit() > 511) {
            LOG.info("Key size lager than 511 bytes which is the limit for LMDB key values");
            return false;
        }
        if (this.threadReadTxn.get() == null) {
            this.threadReadTxn.set((Txn<ByteBuffer>)this.env.txnRead());
        }
        Txn<ByteBuffer> txn = this.threadReadTxn.get();
        txn.reset();
        txn.renew();
        ByteBuffer found = (ByteBuffer)currentDB.get(txn, (Object)key);
        return found != null;
    }

    @Override
    public boolean containsKey(int opID, String key) {
        ByteBuffer temp = MemoryManagerContext.DEFAULT_CHARSET.encode(key);
        ByteBuffer keyBuffertemp = ByteBuffer.allocateDirect(temp.limit());
        keyBuffertemp.put(temp);
        return this.containsKey(opID, keyBuffertemp);
    }

    @Override
    public boolean append(int opID, ByteBuffer key, ByteBuffer value) {
        ByteBuffer results = this.get(opID, key);
        if (value.position() != 0) {
            value.flip();
        }
        if (results == null) {
            return this.put(opID, key, value);
        }
        int capacity = results.limit() + value.limit();
        if (this.threadappendBuffer.get() == null) {
            this.threadappendBuffer.set(ByteBuffer.allocateDirect(2048));
        }
        if (capacity > this.threadappendBuffer.get().capacity()) {
            this.threadappendBuffer.set(ByteBuffer.allocateDirect(capacity * 2));
        }
        this.threadappendBuffer.get().clear();
        this.threadappendBuffer.get().put(results).put(value);
        return this.put(opID, key, this.threadappendBuffer.get());
    }

    @Override
    public boolean append(int opID, String key, ByteBuffer value) {
        ByteBuffer temp = MemoryManagerContext.DEFAULT_CHARSET.encode(key);
        ByteBuffer keyBuffertemp = ByteBuffer.allocateDirect(temp.limit());
        keyBuffertemp.put(temp);
        return this.append(opID, keyBuffertemp, value);
    }

    @Override
    public boolean put(int opID, ByteBuffer key, ByteBuffer value) {
        if (!this.dbMap.containsKey(opID)) {
            LOG.info("The given operation does not have a corresponding store specified");
            return false;
        }
        Dbi<ByteBuffer> currentDB = this.dbMap.get(opID);
        if (currentDB == null) {
            throw new RuntimeException("LMDB database has not been configured. Please initialize database");
        }
        if (key.position() != 0) {
            key.flip();
        }
        if (value.position() != 0) {
            value.flip();
        }
        if (key.limit() > 511) {
            LOG.info("Key size lager than 511 bytes which is the limit for LMDB key values");
            return false;
        }
        currentDB.put((Object)key, (Object)value);
        return true;
    }

    @Override
    public boolean put(int opID, byte[] key, byte[] value) {
        try {
            this.dataQueueMap.get(opID).put((Pair<byte[], byte[]>)new ImmutablePair((Object)key, (Object)value));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public boolean put(int opID, List<ByteBuffer> keys, List<ByteBuffer> values) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean put(int opID, String key, ByteBuffer value) {
        ByteBuffer temp = MemoryManagerContext.DEFAULT_CHARSET.encode(key);
        ByteBuffer keyBuffertemp = ByteBuffer.allocateDirect(temp.limit());
        keyBuffertemp.put(temp);
        return this.put(opID, keyBuffertemp, value);
    }

    @Override
    public boolean delete(int opID, ByteBuffer key) {
        if (!this.dbMap.containsKey(opID)) {
            LOG.info("The given operation does not have a corresponding store specified");
            return false;
        }
        Dbi<ByteBuffer> currentDB = this.dbMap.get(opID);
        if (currentDB == null) {
            throw new RuntimeException("LMDB database has not been configured. Please initialize database");
        }
        if (key.position() != 0) {
            key.flip();
        }
        if (key.limit() > 511) {
            LOG.info("Key size lager than 511 bytes which is the limit for LMDB key values");
            return false;
        }
        currentDB.delete((Object)key);
        return true;
    }

    @Override
    public boolean delete(int opID, String key) {
        ByteBuffer temp = MemoryManagerContext.DEFAULT_CHARSET.encode(key);
        ByteBuffer keyBuffertemp = ByteBuffer.allocateDirect(temp.limit());
        keyBuffertemp.put(temp);
        return this.delete(opID, keyBuffertemp);
    }

    @Override
    public OperationMemoryManager addOperation(int opID, DataMessageType messageType) {
        Dbi<ByteBuffer> currentDB = this.dbMap.get(opID);
        this.dataQueueMap.put(opID, new LinkedBlockingDeque(5000000));
        this.dbMap.put(opID, (Dbi<ByteBuffer>)this.env.openDbi(String.valueOf(opID), new DbiFlags[]{DbiFlags.MDB_CREATE}));
        return new OperationMemoryManager(opID, messageType, this);
    }

    @Override
    public OperationMemoryManager addOperation(int opID, DataMessageType messageType, DataMessageType keyType) {
        this.dataQueueMap.put(opID, new LinkedBlockingDeque(5000000));
        this.dbMap.put(opID, (Dbi<ByteBuffer>)this.env.openDbi(String.valueOf(opID), new DbiFlags[]{DbiFlags.MDB_CREATE}));
        return new OperationMemoryManager(opID, messageType, keyType, this);
    }

    @Override
    public boolean removeOperation(int opID) {
        this.dbMap.get(opID).close();
        this.dbMap.remove(opID);
        return true;
    }

    @Override
    public boolean flush(int opID, ByteBuffer key) {
        return false;
    }

    @Override
    public boolean flush(int opID) {
        return true;
    }

    private void setupThreadLocalBuffers(int keyLength, int dataLength) {
        int dataLengthTemp = dataLength + 4;
        if (this.keyBuffer.capacity() < keyLength) {
            this.keyBuffer = ByteBuffer.allocateDirect(keyLength);
        }
        if (this.dataBuffer.capacity() < dataLengthTemp) {
            this.dataBuffer = ByteBuffer.allocateDirect(dataLengthTemp);
        }
        this.dataBuffer.clear();
        this.keyBuffer.clear();
    }

    @Override
    public boolean flush(int opID, String key) {
        return false;
    }

    @Override
    public boolean close(int opID, ByteBuffer key) {
        return false;
    }

    @Override
    public boolean close(int opID, String key) {
        return false;
    }

    @Override
    public Iterator<Object> getIterator(int opID, DataMessageType keyType, DataMessageType valueType, KryoSerializer deSerializer, ByteOrder order) {
        if (!this.dbMap.containsKey(opID)) {
            LOG.info("The given operation does not have a corresponding store specified");
            return null;
        }
        if (this.threadReadTxn.get() == null) {
            this.threadReadTxn.set((Txn<ByteBuffer>)this.env.txnRead());
        }
        ArrayList<ImmutablePair> results = new ArrayList<ImmutablePair>(50000);
        Dbi<ByteBuffer> currentDB = this.dbMap.get(opID);
        this.lock.lock();
        if (needsCommitWriter.booleanValue()) {
            needsCommitReader = true;
            while (needsCommitReader.booleanValue()) {
            }
        }
        this.lock.unlock();
        int limit = 50000;
        int tempCount = 0;
        boolean firstd = true;
        Txn<ByteBuffer> txn = this.threadReadTxn.get();
        txn.reset();
        txn.renew();
        try (CursorIterator it = currentDB.iterate(txn, KeyRange.all());){
            for (CursorIterator.KeyVal kv : it.iterable()) {
                Object key = MemoryDeserializer.deserializeKey(((ByteBuffer)kv.key()).order(order), keyType, deSerializer);
                Object value = MemoryDeserializer.deserializeValue(((ByteBuffer)kv.val()).order(order), valueType, deSerializer);
                if (firstd) {
                    results.add(new ImmutablePair(key, value));
                } else {
                    results.set(tempCount, new ImmutablePair(key, value));
                }
                if (++tempCount < limit) continue;
                tempCount = 0;
                firstd = false;
                break;
            }
        }
        return results.iterator();
    }

    @Override
    public Iterator<Object> getIterator(int opID, DataMessageType valueType, KryoSerializer deSerializer, ByteOrder order) {
        if (!this.dbMap.containsKey(opID)) {
            LOG.info("The given operation does not have a corresponding store specified");
            return null;
        }
        if (this.threadReadTxn.get() == null) {
            this.threadReadTxn.set((Txn<ByteBuffer>)this.env.txnRead());
        }
        ArrayList<Object> results = new ArrayList<Object>();
        Dbi<ByteBuffer> currentDB = this.dbMap.get(opID);
        this.lock.lock();
        if (needsCommitWriter.booleanValue()) {
            needsCommitReader = true;
            while (needsCommitReader.booleanValue()) {
            }
        }
        this.lock.unlock();
        Txn<ByteBuffer> txn = this.threadReadTxn.get();
        txn.reset();
        txn.renew();
        try (CursorIterator it = currentDB.iterate(txn, KeyRange.all());){
            for (CursorIterator.KeyVal kv : it.iterable()) {
                Object value = MemoryDeserializer.deserializeValue(((ByteBuffer)kv.val()).order(order), valueType, deSerializer);
                results.add(value);
            }
        }
        return results.iterator();
    }

    public Path getLmdbDataPath() {
        return this.lmdbDataPath;
    }

    public void setLmdbDataPath(Path lmdbDataPath) {
        this.lmdbDataPath = lmdbDataPath;
    }

    public Env<ByteBuffer> getEnv() {
        return this.env;
    }

    public void setEnv(Env<ByteBuffer> env) {
        this.env = env;
    }

    public Dbi<ByteBuffer> getDb() {
        return this.db;
    }

    public void setDb(Dbi<ByteBuffer> db) {
        this.db = db;
    }

    static final EnvFlags[] envFlags(boolean writeMap, boolean sync) {
        HashSet<EnvFlags> envFlagSet = new HashSet<EnvFlags>();
        if (writeMap) {
            envFlagSet.add(EnvFlags.MDB_WRITEMAP);
            envFlagSet.add(EnvFlags.MDB_NOTLS);
        }
        if (!sync) {
            envFlagSet.add(EnvFlags.MDB_NOSYNC);
        }
        EnvFlags[] envFlags = new EnvFlags[envFlagSet.size()];
        envFlagSet.toArray(envFlags);
        return envFlags;
    }

    private synchronized Txn<ByteBuffer> requestReadTxn() {
        if (this.readTxns.isEmpty()) {
            throw new RuntimeException("No read Txn avilable");
        }
        return this.readTxns.pop();
    }

    private synchronized void releaseReadTxn(Txn<ByteBuffer> txn) {
        txn.commit();
        txn.reset();
        txn.renew();
        this.readTxns.push(txn);
    }
}

